/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.regex;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springmodules.cache.regex.Match;
import org.springmodules.cache.regex.PatternInvalidSyntaxException;
import org.springmodules.cache.regex.Regex;

public class Perl5Regex
implements Regex {
    private final Pattern pattern;

    public Perl5Regex(String regex) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        try {
            this.pattern = perl5Compiler.compile(regex);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new PatternInvalidSyntaxException(malformedPatternException.getMessage());
        }
    }

    public Match match(String input) {
        Perl5Matcher matcher = new Perl5Matcher();
        boolean matches = matcher.matches(input, this.pattern);
        String[] groups = null;
        if (matches) {
            MatchResult matchResult = matcher.getMatch();
            int groupCount = matchResult.groups();
            groups = new String[groupCount];
            for (int i = 0; i < groupCount; ++i) {
                groups[i] = matchResult.group(i);
            }
        }
        Match match = new Match(matches, groups);
        return match;
    }
}

