/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.proxy;

import java.util.Properties;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springmodules.cache.interceptor.caching.CachingAttributeSourceAdvisor;
import org.springmodules.cache.interceptor.caching.CachingInterceptor;
import org.springmodules.cache.interceptor.caching.EntryStoredListener;
import org.springmodules.cache.interceptor.flush.CacheFlushAttributeSourceAdvisor;
import org.springmodules.cache.interceptor.flush.CacheFlushInterceptor;
import org.springmodules.cache.provider.CacheProviderFacade;

public final class CacheProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private static final long serialVersionUID = 3688501099833603120L;
    private CacheFlushInterceptor cacheFlushInterceptor = new CacheFlushInterceptor();
    private CachingInterceptor cachingInterceptor = new CachingInterceptor();
    private Object proxy;
    private Class[] proxyInterfaces;
    private Object target;

    public void afterPropertiesSet() {
        this.cachingInterceptor.afterPropertiesSet();
        if (this.target == null) {
            throw new IllegalStateException("Property 'target' is required");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor((Advisor)new CachingAttributeSourceAdvisor(this.cachingInterceptor));
        proxyFactory.addAdvisor((Advisor)new CacheFlushAttributeSourceAdvisor(this.cacheFlushInterceptor));
        proxyFactory.copyFrom((ProxyConfig)this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!super.isProxyTargetClass()) {
            if (this.target instanceof TargetSource) {
                throw new AopConfigException("Either 'proxyInterfaces' or 'proxyTargetClass' is required when using a TargetSource as 'target'");
            }
            proxyFactory.setInterfaces(AopUtils.getAllInterfaces((Object)this.target));
        }
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object targetObject) {
        Object targetSource = null;
        targetSource = targetObject instanceof TargetSource ? (TargetSource)targetObject : new SingletonTargetSource(targetObject);
        return targetSource;
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        Class<?> objectType = null;
        if (this.proxy != null) {
            objectType = this.proxy.getClass();
        } else if (this.target != null && this.target instanceof TargetSource) {
            objectType = this.target.getClass();
        }
        return objectType;
    }

    protected Object getProxy() {
        return this.proxy;
    }

    protected Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCacheFlushAttributes(Properties cacheFlushAttributes) {
        this.cacheFlushInterceptor.setCacheFlushAttributes(cacheFlushAttributes);
    }

    public void setCacheProviderFacade(CacheProviderFacade cacheProviderFacade) {
        this.cacheFlushInterceptor.setCacheProviderFacade(cacheProviderFacade);
        this.cachingInterceptor.setCacheProviderFacade(cacheProviderFacade);
    }

    public void setCachingAttributes(Properties cachingAttributes) {
        this.cachingInterceptor.setCachingAttributes(cachingAttributes);
    }

    public void setEntryStoredListener(EntryStoredListener entryStoredListener) {
        this.cachingInterceptor.setEntryStoredListener(entryStoredListener);
    }

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        this.proxyInterfaces = AopUtils.toInterfaceArray((String[])interfaceNames);
    }

    public final void setTarget(Object target) {
        this.target = target;
    }
}

