/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.flush;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CacheAttribute;

public class FlushCache
implements CacheAttribute {
    private static final long serialVersionUID = 3689909557149513778L;
    private String[] cacheProfileIds;
    private boolean flushBeforeExecution;

    public FlushCache() {
    }

    public FlushCache(String cacheProfileIdsCsv) {
        this();
        this.setCacheProfileIds(cacheProfileIdsCsv);
    }

    public FlushCache(String cacheProfileIdsCsv, boolean flushedBeforeExecution) {
        this(cacheProfileIdsCsv);
        this.setFlushBeforeExecution(flushedBeforeExecution);
    }

    public FlushCache(String[] cacheProfileIds) {
        this();
        this.setCacheProfileIds(cacheProfileIds);
    }

    public FlushCache(String[] cacheProfileIds, boolean flushedBeforeExecution) {
        this(cacheProfileIds);
        this.setFlushBeforeExecution(flushedBeforeExecution);
    }

    public boolean equals(Object obj) {
        boolean equals = true;
        if (null == obj || !(obj instanceof FlushCache)) {
            equals = false;
        } else if (this != obj) {
            FlushCache flushCache = (FlushCache)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object[])this.getCacheProfileIds(), (Object[])flushCache.getCacheProfileIds());
            equalsBuilder.append(this.isFlushBeforeExecution(), flushCache.isFlushBeforeExecution());
            equals = equalsBuilder.isEquals();
        }
        return equals;
    }

    public final String[] getCacheProfileIds() {
        return this.cacheProfileIds;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(5, 7);
        hashCodeBuilder.append((Object[])this.getCacheProfileIds());
        hashCodeBuilder.append(this.isFlushBeforeExecution());
        int hashCode = hashCodeBuilder.toHashCode();
        return hashCode;
    }

    public final boolean isFlushBeforeExecution() {
        return this.flushBeforeExecution;
    }

    public final void setCacheProfileIds(String cacheProfileIdsCsv) {
        String[] newProfileIds = StringUtils.commaDelimitedListToStringArray((String)cacheProfileIdsCsv);
        this.setCacheProfileIds(newProfileIds);
    }

    public final void setCacheProfileIds(String[] cacheProfileIds) {
        this.cacheProfileIds = cacheProfileIds;
    }

    public final void setFlushBeforeExecution(boolean flushBeforeExecution) {
        this.flushBeforeExecution = flushBeforeExecution;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("cacheProfileIds", (Object[])this.getCacheProfileIds());
        toStringBuilder.append("flushedBeforeExecution", this.isFlushBeforeExecution());
        String toString = toStringBuilder.toString();
        return toString;
    }
}

