/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;
import org.springmodules.cache.interceptor.caching.CachingInterceptor;

public class CachingAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final long serialVersionUID = 3832897771492356663L;
    private CachingAttributeSource cachingAttributeSource;

    public CachingAttributeSourceAdvisor(CachingInterceptor cacheInterceptor) {
        super((Advice)cacheInterceptor);
        CachingAttributeSource tempAttributeSource = cacheInterceptor.getCachingAttributeSource();
        if (tempAttributeSource == null) {
            String message = "Constructor 'CachingAttributeSourceAdvisor'. CacheFlushInterceptor has no CachingAttributeSource configured";
            throw new AopConfigException(message);
        }
        this.cachingAttributeSource = tempAttributeSource;
    }

    public final boolean matches(Method method, Class targetClass) {
        Cached attribute = this.cachingAttributeSource.getCachingAttribute(method, targetClass);
        boolean matches = attribute != null;
        return matches;
    }
}

