/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.data.loader;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.tools.data.loader.DataLoader;
import org.openvpms.tools.data.loader.LoadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class StaxArchetypeDataLoader {
    private final IArchetypeService service;
    private final LoadCache cache = new LoadCache();
    private final Map<String, Long> statistics = new HashMap<String, Long>();
    private boolean verbose;
    private boolean validateOnly;
    private int batchSize;
    private static final Logger log = LoggerFactory.getLogger(StaxArchetypeDataLoader.class);
    private static final String DEFAULT_APP_CONTEXT_FNAME = "application-context.xml";
    private static final String EXTENSION = "xml";

    public StaxArchetypeDataLoader(IArchetypeService service) {
        this.service = service;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void load(String ... paths) throws IOException, XMLStreamException {
        Date start = new Date();
        DataLoader loader = new DataLoader(this.cache, this.service, this.verbose, this.validateOnly, this.batchSize, this.statistics);
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) {
                this.processDir(file, loader);
                continue;
            }
            this.processFile(file, loader);
        }
        loader.close();
        this.dumpStatistics(start);
    }

    public static void main(String[] args) {
        try {
            JSAP parser = StaxArchetypeDataLoader.createParser();
            JSAPResult config = parser.parse(args);
            String[] files = config.getStringArray("file");
            String dir = config.getString("dir");
            if (!config.success() || files.length == 0 && dir == null) {
                StaxArchetypeDataLoader.displayUsage(parser, config);
            } else {
                String contextPath = config.getString("context");
                Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
                StaxArchetypeDataLoader loader = new StaxArchetypeDataLoader(service);
                loader.setVerbose(config.getBoolean("verbose"));
                loader.setValidateOnly(config.getBoolean("validateOnly"));
                loader.setBatchSize(config.getInt("batchSaveSize"));
                if (files.length != 0) {
                    loader.load(files);
                } else {
                    loader.load(dir);
                }
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            System.exit(1);
        }
    }

    private void processDir(File dir, DataLoader loader) throws IOException, XMLStreamException {
        String[] extensions = new String[]{EXTENSION};
        Collection collection = FileUtils.listFiles((File)dir, (String[])extensions, (boolean)false);
        Object[] files = FileUtils.convertFileCollectionToFileArray((Collection)collection);
        Arrays.sort(files);
        for (Object file : files) {
            this.processFile((File)file, loader);
            loader.flush();
        }
    }

    private void processFile(File file, DataLoader loader) throws XMLStreamException, IOException {
        log.info("\n[PROCESSING FILE : " + file + "]\n");
        try (FileInputStream stream = new FileInputStream(file);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLStreamReader reader = factory.createXMLStreamReader(stream);
            loader.load(reader, file.getPath());
        }
    }

    private void dumpStatistics(Date start) {
        Date end = new Date();
        double elapsed = (double)(end.getTime() - start.getTime()) / 1000.0;
        log.info("\n\n\n[STATISTICS]\n");
        int total = 0;
        for (String shortName : this.statistics.keySet()) {
            Long count = this.statistics.get(shortName);
            total = (int)((long)total + count);
            log.info(String.format("%42s %6d", shortName, count));
        }
        double rate = elapsed != 0.0 ? (double)total / elapsed : 0.0;
        log.info(String.format("Processed %d objects in %.2f seconds (%.2f objects/sec)", total, elapsed, rate));
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("context").setShortFlag('c').setLongFlag("context").setDefault(DEFAULT_APP_CONTEXT_FNAME).setHelp("Application context for the data loader"));
        parser.registerParameter(new FlaggedOption("dir").setShortFlag('d').setLongFlag("dir").setHelp("Directory where data files reside."));
        parser.registerParameter(new Switch("subdir").setShortFlag('s').setLongFlag("subdir").setDefault("false").setHelp("Search the subdirectories as well."));
        parser.registerParameter(new FlaggedOption("file").setShortFlag('f').setList(true).setListSeparator(',').setLongFlag("file").setHelp("Name of file containing data"));
        parser.registerParameter(new Switch("verbose").setShortFlag('v').setLongFlag("verbose").setDefault("false").setHelp("Displays verbose info to the console."));
        parser.registerParameter(new Switch("validateOnly").setLongFlag("validateOnly").setDefault("false").setHelp("Only validate the data file. Do not process."));
        parser.registerParameter(new FlaggedOption("batchSaveSize").setStringParser((StringParser)JSAP.INTEGER_PARSER).setDefault("0").setShortFlag('b').setLongFlag("batchSaveSize").setHelp("The batch size for saving objects."));
        return parser;
    }

    private static void displayUsage(JSAP parser, JSAPResult result) {
        Iterator iter = result.getErrorMessageIterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
        System.err.println();
        System.err.println("Usage: java " + StaxArchetypeDataLoader.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }
}

