/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.data.loader;

import com.thoughtworks.xstream.converters.basic.DateConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.tools.data.loader.ArchetypeDataLoaderException;
import org.openvpms.tools.data.loader.DeferredUpdater;
import org.openvpms.tools.data.loader.LoadCache;
import org.openvpms.tools.data.loader.LoadContext;
import org.openvpms.tools.data.loader.UnsavedRefUpdater;

class LoadState {
    public static final String ID_PREFIX = "id:";
    private final IMObject object;
    private final List<LoadState> childStates = new ArrayList<LoadState>();
    private final LoadState parent;
    private final ArchetypeDescriptor descriptor;
    private final String path;
    private final int lineNo;
    private final String id;
    private Map<String, DeferredUpdater> deferred = new HashMap<String, DeferredUpdater>();
    private Map<Integer, DeferredUpdater> deferredCache = new HashMap<Integer, DeferredUpdater>();
    private Map<IMObjectReference, UnsavedRefUpdater> unsaved = new HashMap<IMObjectReference, UnsavedRefUpdater>();
    private Set<IMObjectReference> unsavedCache = new HashSet<IMObjectReference>();
    private int depth;

    public LoadState(LoadState parent, IMObject object, ArchetypeDescriptor descriptor, String path, int lineNo, String id) {
        this.parent = parent;
        this.object = object;
        this.descriptor = descriptor;
        this.path = path;
        this.lineNo = lineNo;
        this.id = id;
    }

    public LoadState getParent() {
        return this.parent;
    }

    public IMObject getObject() {
        return this.object;
    }

    public String getArchetype() {
        return this.object.getArchetype();
    }

    public void setValue(String name, String value, LoadContext context) {
        NodeDescriptor node = this.getNode(name);
        try {
            if (value.startsWith(ID_PREFIX)) {
                if (node.isCollection()) {
                    value = LoadCache.stripPrefix(value);
                    this.addChild(node, value, context);
                } else {
                    this.setReference(node, value, context);
                }
            } else if (node.isDate()) {
                node.setValue(this.object, this.getDate(value));
            } else {
                node.setValue(this.object, value);
            }
        }
        catch (Exception exception) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.FailedToSetAtribute, exception, name, value, this.lineNo);
        }
    }

    public Collection<DeferredUpdater> getDeferred() {
        return this.deferredCache.values();
    }

    public ArchetypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isComplete() {
        return this.deferredCache.isEmpty();
    }

    public void addChild(String collection, final LoadState child) {
        final NodeDescriptor node = this.getNode(collection);
        if (!node.isCollection()) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.ParentNotACollection, this.lineNo);
        }
        if (child.isComplete()) {
            node.addChildToCollection(this.object, child.getObject());
            this.childStates.add(child);
        } else {
            DeferredUpdater updater = child.getDeferred().iterator().next();
            DeferredUpdater childUpdater = new DeferredUpdater(updater.getId()){

                @Override
                public boolean update(IMObjectReference reference, LoadContext context) {
                    if (child.isComplete()) {
                        node.addChildToCollection(LoadState.this.object, child.getObject());
                        LoadState.this.childStates.add(child);
                        LoadState.this.removeDeferred(this.getId());
                        return true;
                    }
                    return false;
                }
            };
            this.addDeferred(childUpdater);
        }
    }

    public void addChild(String collection, String id, LoadContext context) {
        NodeDescriptor node = this.getNode(collection);
        if (!node.isCollection()) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.ParentNotACollection, this.lineNo);
        }
        id = LoadCache.stripPrefix(id);
        this.addChild(node, id, context);
    }

    public Set<IMObjectReference> getUnsaved() {
        return this.unsavedCache;
    }

    public void update(IMObjectReference reference) {
        UnsavedUpdaterVisitor visitor = new UnsavedUpdaterVisitor(reference);
        visitor.visit(this);
    }

    public void removeUnsaved(IMObjectReference reference) {
        this.unsaved.remove(reference);
        this.removeUnsavedCache(reference);
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getId() {
        return this.id;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    private boolean setReference(final NodeDescriptor descriptor, final String id, LoadContext context) {
        boolean result = false;
        IMObjectReference ref = context.getReference(id);
        if (ref == null) {
            if (!this.deferred.containsKey(id)) {
                this.addDeferred(new DeferredUpdater(id){

                    @Override
                    public boolean update(IMObjectReference reference, LoadContext context) {
                        if (LoadState.this.setReference(descriptor, id, context)) {
                            LoadState.this.removeDeferred(this.getId());
                            return true;
                        }
                        return false;
                    }
                });
            }
        } else {
            descriptor.setValue(this.object, ref);
            result = true;
            if (ref.isNew()) {
                if (this.unsaved == null) {
                    this.unsaved = new HashMap<IMObjectReference, UnsavedRefUpdater>();
                }
                this.addUnsaved(ref, descriptor);
            }
        }
        return result;
    }

    private boolean addChild(final NodeDescriptor node, final String id, LoadContext context) {
        boolean result = false;
        IMObject child = context.getObject(id);
        if (child != null) {
            node.addChildToCollection(this.object, child);
            result = true;
        } else {
            this.addDeferred(new DeferredUpdater(id){

                @Override
                public boolean update(IMObjectReference reference, LoadContext context) {
                    if (LoadState.this.addChild(node, id, context)) {
                        LoadState.this.removeDeferred(id);
                        return true;
                    }
                    return false;
                }
            });
        }
        return result;
    }

    private NodeDescriptor getNode(String name) {
        NodeDescriptor ndesc = this.descriptor.getNodeDescriptor(name);
        if (ndesc == null) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.InvalidAttribute, this.lineNo, name, this.descriptor.getType());
        }
        return ndesc;
    }

    private void addDeferred(DeferredUpdater updater) {
        String id = updater.getId();
        this.removeDeferred(id);
        this.deferred.put(id, updater);
        this.addDeferredCache(updater);
    }

    private void addDeferredCache(DeferredUpdater updater) {
        this.deferredCache.put(System.identityHashCode(updater), updater);
        if (this.parent != null) {
            this.parent.addDeferredCache(updater);
        }
    }

    private void removeDeferred(String id) {
        DeferredUpdater updater = this.deferred.remove(id);
        if (updater != null) {
            this.removeDeferredCache(updater);
        }
    }

    private void removeDeferredCache(DeferredUpdater updater) {
        this.deferredCache.remove(System.identityHashCode(updater));
        if (this.parent != null) {
            this.parent.removeDeferredCache(updater);
        }
    }

    private void addUnsaved(IMObjectReference ref, NodeDescriptor descriptor) {
        this.unsaved.put(ref, new UnsavedRefUpdater(this, ref, descriptor));
        this.addUnsavedCache(ref);
    }

    private void addUnsavedCache(IMObjectReference reference) {
        this.unsavedCache.add(reference);
        if (this.parent != null) {
            this.parent.addUnsavedCache(reference);
        }
    }

    private void removeUnsavedCache(IMObjectReference reference) {
        this.unsavedCache.remove(reference);
        if (this.parent != null) {
            this.parent.removeUnsaved(reference);
        }
    }

    private Date getDate(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String defaultFormat = "yyyy-MM-dd HH:mm:ss.S z";
        String[] acceptableFormats = new String[]{"yyyy-MM-dd HH:mm:ss.S a", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ssa", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy"};
        DateConverter converter = new DateConverter(defaultFormat, acceptableFormats);
        return (Date)converter.fromString(value);
    }

    private static class UnsavedUpdaterVisitor
    extends Visitor {
        private final IMObjectReference reference;

        public UnsavedUpdaterVisitor(IMObjectReference reference) {
            this.reference = reference;
        }

        @Override
        protected boolean doVisit(LoadState state) {
            UnsavedRefUpdater updater;
            Map unsaved = state.unsaved;
            if (unsaved != null && (updater = (UnsavedRefUpdater)unsaved.get(this.reference)) != null) {
                updater.update(this.reference);
            }
            return true;
        }
    }

    private static abstract class Visitor {
        private Set<LoadState> visited = new HashSet<LoadState>();

        private Visitor() {
        }

        public boolean visit(LoadState state) {
            this.addVisited(state);
            boolean result = this.doVisit(state);
            if (result) {
                result = this.visitChildren(state);
            }
            return result;
        }

        protected abstract boolean doVisit(LoadState var1);

        protected boolean visitChildren(LoadState state) {
            boolean result = true;
            for (LoadState child : state.childStates) {
                if (this.visited.contains(child) || this.visit(child)) continue;
                result = false;
                break;
            }
            return result;
        }

        protected void addVisited(LoadState state) {
            this.visited.add(state);
        }
    }
}

