/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.loader;

import java.util.ArrayList;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.tools.archetype.comparator.ArchetypeComparator;
import org.openvpms.tools.archetype.comparator.FieldChange;
import org.openvpms.tools.archetype.comparator.NodeChange;
import org.openvpms.tools.archetype.comparator.NodeFieldChange;
import org.openvpms.tools.archetype.loader.DescriptorUpdater;

public class ArchetypeUpdater
extends DescriptorUpdater<ArchetypeDescriptor> {
    @Override
    public boolean update(ArchetypeDescriptor target, ArchetypeDescriptor source) {
        boolean updated = false;
        ArchetypeComparator comparator = new ArchetypeComparator();
        ArchetypeChange change = comparator.compare(target, source);
        if (change != null) {
            for (FieldChange fieldChange : change.getFieldChanges()) {
                this.updateArchetypeDescriptorField(target, fieldChange);
                updated = true;
            }
            for (NodeChange nodeChange : change.getNodeChanges()) {
                if (nodeChange.isAdd()) {
                    target.addNodeDescriptor((NodeDescriptor)nodeChange.getNewVersion());
                } else if (nodeChange.isUpdate()) {
                    for (NodeFieldChange nodeFieldChange : nodeChange.getChanges()) {
                        NodeDescriptor nodeDescriptor = target.getNodeDescriptor(nodeChange.getName());
                        this.updateNodeDescriptorField(nodeDescriptor, nodeFieldChange);
                    }
                } else {
                    NodeDescriptor deleted = target.getNodeDescriptor(nodeChange.getName());
                    if (deleted != null) {
                        target.removeNodeDescriptor(deleted);
                    }
                }
                updated = true;
            }
        }
        return updated;
    }

    private void updateArchetypeDescriptorField(ArchetypeDescriptor descriptor, FieldChange change) {
        switch (change.getField()) {
            case NAME: {
                descriptor.setName(this.toString(change));
                break;
            }
            case DISPLAY_NAME: {
                descriptor.setDisplayName(this.toString(change));
                break;
            }
            case CLASS_NAME: {
                descriptor.setClassName(this.toString(change));
                break;
            }
            case PRIMARY: {
                descriptor.setPrimary(this.toBoolean(change));
                break;
            }
            case SINGLETON: {
                descriptor.setSingleton(this.toBoolean(change));
                break;
            }
            case ACTIVE: {
                descriptor.setActive(this.toBoolean(change));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot update " + descriptor.getArchetypeType() + ": unsupported field " + (Object)((Object)change.getField()));
            }
        }
    }

    private void updateNodeDescriptorField(NodeDescriptor descriptor, NodeFieldChange change) {
        switch (change.getField()) {
            case DESCRIPTION: {
                descriptor.setDescription(this.toString(change));
                break;
            }
            case DISPLAY_NAME: {
                descriptor.setDisplayName(this.toString(change));
                break;
            }
            case TYPE: {
                descriptor.setType(this.toString(change));
                break;
            }
            case BASE_NAME: {
                descriptor.setBaseName(this.toString(change));
                break;
            }
            case PATH: {
                descriptor.setPath(this.toString(change));
                break;
            }
            case PARENT_CHILD: {
                descriptor.setParentChild(this.toBoolean(change));
                break;
            }
            case MIN_LENGTH: {
                descriptor.setMinLength(this.toInt(change));
                break;
            }
            case MAX_LENGTH: {
                descriptor.setMaxLength(this.toInt(change));
                break;
            }
            case MIN_CARDINALITY: {
                descriptor.setMinCardinality(this.toInt(change));
                break;
            }
            case MAX_CARDINALITY: {
                descriptor.setMaxCardinality(this.toInt(change, 1));
                break;
            }
            case FILTER: {
                descriptor.setFilter(this.toString(change));
                break;
            }
            case INDEX: {
                descriptor.setIndex(this.toInt(change));
                break;
            }
            case DEFAULT_VALUE: {
                descriptor.setDefaultValue(this.toString(change));
                break;
            }
            case READ_ONLY: {
                descriptor.setReadOnly(this.toBoolean(change));
                break;
            }
            case HIDDEN: {
                descriptor.setHidden(this.toBoolean(change));
                break;
            }
            case DERIVED: {
                descriptor.setDerived(this.toBoolean(change));
                break;
            }
            case DERIVED_VALUE: {
                descriptor.setDerivedValue(this.toString(change));
                break;
            }
            case ASSERTION: {
                this.updateAssertionDescriptor(descriptor, change);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot update " + descriptor.getName() + ": unsupported field " + (Object)((Object)change.getField()));
            }
        }
    }

    private void updateAssertionDescriptor(NodeDescriptor descriptor, NodeFieldChange change) {
        if (change.isAdd()) {
            descriptor.addAssertionDescriptor((AssertionDescriptor)change.getNewVersion());
        } else if (change.isUpdate()) {
            AssertionDescriptor existing = (AssertionDescriptor)change.getOldVersion();
            AssertionDescriptor newVersion = (AssertionDescriptor)change.getNewVersion();
            existing.setIndex(newVersion.getIndex());
            existing.setErrorMessage(newVersion.getErrorMessage());
            for (NamedProperty property : new ArrayList(existing.getPropertyMap().getProperties().values())) {
                existing.removeProperty(property);
            }
            for (NamedProperty property : newVersion.getPropertyMap().getProperties().values()) {
                existing.addProperty(property);
            }
        } else {
            descriptor.removeAssertionDescriptor((AssertionDescriptor)change.getOldVersion());
        }
    }
}

