/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.diff;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptorWriter;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.tools.archetype.comparator.ArchetypeComparator;
import org.openvpms.tools.archetype.comparator.DescriptorChange;
import org.openvpms.tools.archetype.comparator.FieldChange;
import org.openvpms.tools.archetype.comparator.NodeChange;
import org.openvpms.tools.archetype.comparator.NodeFieldChange;
import org.openvpms.tools.archetype.io.ArchetypeServiceLoader;
import org.openvpms.tools.archetype.io.DescriptorLoader;
import org.openvpms.tools.archetype.io.FileSystemLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ArchDiff {
    private final ArchetypeComparator comparator = new ArchetypeComparator();
    private final IArchetypeService service;
    private ArchetypeDescriptorWriter writer;
    private static final Logger log = LoggerFactory.getLogger(ArchDiff.class);
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    public ArchDiff(IArchetypeService service) {
        this.service = service;
        this.writer = new ArchetypeDescriptorWriter(true, true);
    }

    public void compare(DescriptorLoader oldVersion, DescriptorLoader newVersion, boolean verbose) throws IOException {
        Map<String, ArchetypeDescriptor> oldDescriptors = oldVersion.getDescriptors();
        Map<String, ArchetypeDescriptor> newDescriptors = newVersion.getDescriptors();
        if (oldDescriptors.isEmpty()) {
            System.err.println("No archetypes found in " + oldVersion);
        } else if (newDescriptors.isEmpty()) {
            System.err.println("No archetypes found in " + newVersion);
        } else {
            TreeSet<String> shortNames = new TreeSet<String>();
            if (oldVersion.isAll() == newVersion.isAll()) {
                shortNames.addAll(oldDescriptors.keySet());
                shortNames.addAll(newDescriptors.keySet());
            } else if (oldVersion.isAll()) {
                shortNames.addAll(newDescriptors.keySet());
            } else {
                shortNames.addAll(oldDescriptors.keySet());
            }
            for (String shortName : shortNames) {
                ArchetypeDescriptor oldDescriptor = oldDescriptors.get(shortName);
                ArchetypeDescriptor newDescriptor = newDescriptors.get(shortName);
                this.compare(oldDescriptor, newDescriptor, verbose);
            }
        }
    }

    public void list(DescriptorLoader loader, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("Retrieving archetype descriptors from: " + loader);
        }
        Map<String, ArchetypeDescriptor> descriptors = loader.getDescriptors();
        if (verbose) {
            System.out.println("Found " + descriptors.size() + " descriptors");
        }
        for (String shortName : new TreeSet<String>(descriptors.keySet())) {
            System.out.println(shortName);
        }
    }

    public DescriptorLoader getDescriptorLoader(String source, boolean recurse) {
        if ("db".equals(source)) {
            return new ArchetypeServiceLoader(this.service);
        }
        return new FileSystemLoader(source, recurse);
    }

    public static void main(String[] args) {
        try {
            JSAP parser = ArchDiff.createParser();
            JSAPResult config = parser.parse(args);
            if (!config.success()) {
                ArchDiff.displayUsage(parser, config);
            } else {
                boolean recurse = !config.getBoolean("no-recurse");
                boolean verbose = config.getBoolean("verbose");
                String contextPath = config.getString("context");
                String version1 = config.getString("version1");
                String version2 = config.getString("version2");
                if (!StringUtils.isEmpty((CharSequence)version1) && !StringUtils.isEmpty((CharSequence)version2)) {
                    Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                    IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
                    ArchDiff diff = new ArchDiff(service);
                    if (config.getBoolean("list")) {
                        DescriptorLoader loader = diff.getDescriptorLoader(version1, recurse);
                        diff.list(loader, verbose);
                    } else {
                        DescriptorLoader oldVersion = diff.getDescriptorLoader(version1, recurse);
                        DescriptorLoader newVersion = diff.getDescriptorLoader(version2, recurse);
                        diff.compare(oldVersion, newVersion, verbose);
                    }
                } else {
                    ArchDiff.displayUsage(parser, config);
                }
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    private void compare(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion, boolean verbose) throws IOException {
        ArchetypeChange change = this.comparator.compare(oldVersion, newVersion);
        if (change != null) {
            System.out.println(this.getChangeType(change) + " " + change.getShortName());
            if (verbose && change.isUpdate()) {
                for (FieldChange field : change.getFieldChanges()) {
                    System.out.println("  " + this.getChangeType(field) + " " + (Object)((Object)field.getField()) + " " + field.getOldVersion() + " -> " + field.getNewVersion());
                }
                for (NodeChange node : change.getNodeChanges()) {
                    System.out.println("  " + this.getChangeType(node) + " " + node.getName());
                    for (NodeFieldChange fieldChange : node.getChanges()) {
                        System.out.println("    " + (Object)((Object)fieldChange.getField()));
                        this.print(fieldChange.getField(), fieldChange.getOldVersion());
                        System.out.println("    ->");
                        this.print(fieldChange.getField(), fieldChange.getNewVersion());
                    }
                }
            }
        }
    }

    private void print(NodeFieldChange.Field type, Object value) throws IOException {
        String[] values;
        String result;
        if (type == NodeFieldChange.Field.ASSERTION && value instanceof AssertionDescriptor) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.writer.write((AssertionDescriptor)value, (OutputStream)stream);
            result = stream.toString("UTF-8");
        } else {
            result = value != null ? value.toString() : "<empty>";
        }
        for (String line : values = result.split("\n")) {
            System.out.println("       " + line);
        }
    }

    private String getChangeType(DescriptorChange change) {
        String type = change.isAdd() ? "A" : (change.isUpdate() ? "U" : "D");
        return type;
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new Switch("verbose").setShortFlag('v').setLongFlag("verbose").setDefault("false").setHelp("Displays verbose info to the console."));
        parser.registerParameter(new Switch("no-recurse").setShortFlag('n').setLongFlag("no-recurse").setDefault("false").setHelp("Disable search of subdirectories."));
        parser.registerParameter(new Switch("list").setShortFlag('l').setLongFlag("list").setDefault("false").setHelp("List archetypes."));
        parser.registerParameter(new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("The application context path"));
        parser.registerParameter(new UnflaggedOption("version1").setRequired(true).setHelp("The first version to compare."));
        parser.registerParameter(new UnflaggedOption("version2").setRequired(false).setDefault("db").setHelp("The second version to compare."));
        return parser;
    }

    private static void displayUsage(JSAP parser, JSAPResult result) {
        Iterator iter = result.getErrorMessageIterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
        System.err.println();
        System.err.println("Usage: archdiff " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.err.println("Versions");
        System.err.println();
        System.err.println("The version1 and version2 arguments specify the older and newer versions of archetypes.");
        System.err.println("They may be:");
        System.err.println(". an .adl file");
        System.err.println(". a directory. All .adl files in the directory will be read.");
        System.err.println(". database (or db) - all archetypes in the database will be read");
        System.err.println("Examples:");
        System.err.println("1. Compare a directory with archetypes in the database");
        System.err.println("> archdiff -v ../archetypes");
        System.err.println(" The above is short-hand for: ");
        System.err.println("> archdiff -v ../archetypes db");
        System.err.println();
        System.err.println("2. Compare a file with a prior version in the database");
        System.err.println("> archdiff -v db ../archetypes/contact.location.adl");
        System.err.println();
        System.err.println("3. Compare two directories containing archetypes");
        System.err.println("> archdiff 1.5/archetypes 1.6/archetypes");
        System.err.println();
        System.err.println("4. List archetypes in the database");
        System.err.println("> archdiff -l db");
        System.exit(1);
    }
}

