/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.comparator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.tools.archetype.comparator.AbstractComparator;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.tools.archetype.comparator.FieldChange;
import org.openvpms.tools.archetype.comparator.NodeChange;
import org.openvpms.tools.archetype.comparator.NodeComparator;

public class ArchetypeComparator
extends AbstractComparator {
    private final NodeComparator comparator = new NodeComparator();

    public ArchetypeChange compare(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion) {
        ArchetypeChange result;
        if (oldVersion != null && newVersion != null) {
            List<FieldChange> fieldChanges = this.getFieldChanges(oldVersion, newVersion);
            List<NodeChange> nodeChanges = this.getNodeChanges(oldVersion, newVersion);
            result = fieldChanges.isEmpty() && nodeChanges.isEmpty() ? null : new ArchetypeChange(oldVersion, newVersion, fieldChanges, nodeChanges);
        } else {
            result = oldVersion == null && newVersion == null ? null : new ArchetypeChange(oldVersion, newVersion);
        }
        return result;
    }

    private List<NodeChange> getNodeChanges(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion) {
        NodeDescriptor node;
        ArrayList<NodeChange> result = new ArrayList<NodeChange>();
        Map oldNodes = oldVersion.getNodeDescriptorMap();
        Map newNodes = newVersion.getNodeDescriptorMap();
        Set<String> added = this.getAdded(oldNodes, newNodes);
        Set<String> deleted = this.getDeleted(oldNodes, newNodes);
        Set<String> retained = this.getRetained(oldNodes, newNodes);
        for (String addedNode : added) {
            node = (NodeDescriptor)newNodes.get(addedNode);
            result.add(new NodeChange(null, node));
        }
        for (String deletedNode : deleted) {
            node = (NodeDescriptor)oldNodes.get(deletedNode);
            result.add(new NodeChange(node, null));
        }
        for (String retainedNode : retained) {
            NodeDescriptor newNode;
            NodeDescriptor oldNode = (NodeDescriptor)oldNodes.get(retainedNode);
            NodeChange change = this.comparator.compare(oldNode, newNode = (NodeDescriptor)newNodes.get(retainedNode));
            if (change == null) continue;
            result.add(change);
        }
        return result;
    }

    private List<FieldChange> getFieldChanges(ArchetypeDescriptor oldVersion, ArchetypeDescriptor newVersion) {
        ArrayList<FieldChange> result = new ArrayList<FieldChange>();
        this.compare(FieldChange.Field.NAME, oldVersion.getName(), newVersion.getName(), result);
        this.compare(FieldChange.Field.DISPLAY_NAME, oldVersion.getDisplayName(), newVersion.getDisplayName(), result);
        this.compare(FieldChange.Field.CLASS_NAME, oldVersion.getClassName(), newVersion.getClassName(), result);
        this.compare(FieldChange.Field.ACTIVE, oldVersion.isActive(), newVersion.isActive(), result);
        this.compare(FieldChange.Field.PRIMARY, oldVersion.isPrimary(), newVersion.isPrimary(), result);
        this.compare(FieldChange.Field.SINGLETON, oldVersion.isSingleton(), newVersion.isSingleton(), result);
        return result;
    }

    private void compare(FieldChange.Field field, Object oldVersion, Object newVersion, List<FieldChange> changes) {
        if (!Objects.equals(oldVersion, newVersion)) {
            changes.add(new FieldChange(field, oldVersion, newVersion));
        }
    }
}

