/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.service.uuid;

import org.openvpms.component.system.service.uuid.IUUIDGenerator;
import org.openvpms.component.system.service.uuid.UUIDServiceException;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.UUIDGenerator;

public class JUGGenerator
implements IUUIDGenerator {
    private UUIDGenerator generator;
    private EthernetAddress ethernetAddress;

    public JUGGenerator() {
        this(UUIDGenerator.getInstance().getDummyAddress().toString());
    }

    public JUGGenerator(String ethernetAddress) throws UUIDServiceException {
        try {
            this.generator = UUIDGenerator.getInstance();
            this.ethernetAddress = new EthernetAddress(ethernetAddress);
        }
        catch (Exception exception) {
            throw new UUIDServiceException(UUIDServiceException.ErrorCode.FailedToInitializeService, new Object[]{this.getClass().getName()}, exception);
        }
    }

    @Override
    public String nextId() {
        return this.generator.generateTimeBasedUUID(this.ethernetAddress).toString();
    }

    @Override
    public String nextId(String prefix) {
        return new StringBuffer(prefix).append(this.generator.generateTimeBasedUUID(this.ethernetAddress).toString()).toString();
    }
}

