/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.util;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.perl.Perl5Util;

public class StringUtilities {
    private static final String CNTRL_CHARS = "[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]";
    private static final Pattern CONTAINS = Pattern.compile("(?s).*[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F].*");
    private static final Pattern REPLACE = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]");

    public static String unCamelCase(String name) {
        ArrayList<String> words = new ArrayList<String>();
        Perl5Util perl = new Perl5Util();
        while (perl.match("/(\\w+?)([A-Z].*)/", name)) {
            String word = perl.group(1);
            name = perl.group(2);
            words.add(StringUtils.capitalize((String)word));
        }
        words.add(StringUtils.capitalize((String)name));
        return StringUtils.join(words.iterator(), (String)" ");
    }

    public static String toRegEx(String input) {
        return input.replace(".", "\\.").replace("*", ".*");
    }

    public static boolean matches(String str, String expression) {
        if (!expression.contains("*")) {
            return str.equals(expression);
        }
        return str.matches(StringUtilities.toRegEx(expression));
    }

    public static boolean hasControlChars(String str) {
        return str != null && CONTAINS.matcher(str).matches();
    }

    public static String replaceControlChars(String str, String with) {
        if (str != null) {
            str = REPLACE.matcher(str).replaceAll(with);
        }
        return str;
    }
}

