/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IterableChain<T>
implements Iterable<T> {
    private final Iterable<T>[] iterables;

    @SafeVarargs
    public IterableChain(Iterable<T> ... iterables) {
        this.iterables = iterables;
    }

    public IterableChain(T singleton, Iterable<T> iterable) {
        this(new Iterable[]{Collections.singletonList(singleton), iterable});
    }

    public IterableChain(Iterable<T> iterable, T singleton) {
        this(new Iterable[]{iterable, Collections.singletonList(singleton)});
    }

    @Override
    public Iterator<T> iterator() {
        return new ChainedIterator();
    }

    private class ChainedIterator
    implements Iterator<T> {
        private int index = 0;
        private Iterator<T> iter;

        @Override
        public boolean hasNext() {
            if (this.iter == null || !this.iter.hasNext()) {
                this.advance();
            }
            return this.iter != null && this.iter.hasNext();
        }

        @Override
        public T next() {
            if (this.iter == null || !this.iter.hasNext()) {
                this.advance();
                if (this.iter == null || !this.iter.hasNext()) {
                    throw new NoSuchElementException();
                }
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.iter == null || !this.iter.hasNext()) {
                if (this.index < IterableChain.this.iterables.length) {
                    this.iter = IterableChain.this.iterables[this.index].iterator();
                    ++this.index;
                    continue;
                }
                return;
            }
        }
    }
}

