/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;

public abstract class UpdatableQueryIterator<T>
implements Iterator<T> {
    private final ArchetypeQuery query;
    private final PageIterator iterator;
    private final IArchetypeService service;
    private IPage<T> page;
    private boolean updated;

    protected UpdatableQueryIterator(ArchetypeQuery query, int pageSize, IArchetypeService service) {
        query.setMaxResults(pageSize);
        this.query = query;
        this.iterator = new PageIterator();
        this.service = service;
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        this.advance();
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void updated() {
        this.updated = true;
    }

    protected abstract IPage<T> getNext(ArchetypeQuery var1, IArchetypeService var2);

    protected abstract long getId(T var1);

    protected IPage<T> getNextPage(boolean reset, IPage<T> lastPage) {
        if (reset) {
            this.query.setFirstResult(0);
        } else if (lastPage != null) {
            this.query.setFirstResult(lastPage.getFirstResult() + lastPage.getResults().size());
        }
        return this.getNext(this.query, this.service);
    }

    protected void advance() {
        if (!this.iterator.hasNext()) {
            boolean done = false;
            while (!done) {
                this.page = this.getNextPage(this.updated, this.page);
                this.iterator.setPage(this.page);
                this.updated = false;
                if (!this.page.getResults().isEmpty() && !this.iterator.hasNext()) continue;
                done = true;
            }
        }
    }

    private class PageIterator
    implements Iterator<T> {
        private final Set<Long> ids = new HashSet<Long>();
        private Iterator<T> iterator;
        private T next;

        private PageIterator() {
        }

        public void setPage(IPage<T> page) {
            this.iterator = page.getResults().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator != null && this.next == null) {
                while (this.iterator.hasNext()) {
                    Object object = this.iterator.next();
                    long id = UpdatableQueryIterator.this.getId(object);
                    if (!this.ids.add(id)) continue;
                    this.next = object;
                    break;
                }
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

