/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.List;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.system.common.query.criteria.MappedCriteriaQuery;

public class TypedQueryImpl<X, Y>
implements TypedQuery<X> {
    private final MappedCriteriaQuery<Y> criteriaQuery;
    private final Class<X> type;
    private final IMObjectDAO dao;
    private int firstResult = 0;
    private int maxResults = Integer.MAX_VALUE;

    public TypedQueryImpl(MappedCriteriaQuery<Y> criteriaQuery, Class<X> type, IMObjectDAO dao) {
        this.criteriaQuery = criteriaQuery;
        this.type = type;
        this.dao = dao;
    }

    public List<X> getResultList() {
        return this.dao.getResults(this.criteriaQuery, this.type, this.firstResult, this.maxResults);
    }

    public X getSingleResult() {
        return this.dao.getSingleResult(this.criteriaQuery, this.type);
    }

    public X getFirstResult() {
        List list = this.setMaxResults(1).getResultList();
        return !list.isEmpty() ? (X)list.get(0) : null;
    }

    public TypedQuery<X> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public TypedQuery<X> setFirstResult(int position) {
        this.firstResult = position;
        return this;
    }
}

