/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.Iterator;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;

public abstract class QueryIterator<T>
implements Iterator<T> {
    private final IArchetypeService service;
    private IArchetypeQuery query;
    private IPage<T> page;
    private Iterator<T> iterator;

    public QueryIterator(IArchetypeService service, IArchetypeQuery query) {
        this.service = service;
        this.query = query;
    }

    @Override
    public boolean hasNext() {
        if (!(this.page != null && this.iterator.hasNext() || this.page != null && (this.query.getMaxResults() == -1 || this.page.getResults().size() < this.query.getMaxResults()))) {
            this.page = this.getPage(this.service, this.query);
            if (this.query.getMaxResults() != -1) {
                int first = this.query.getFirstResult() + this.query.getMaxResults();
                this.query.setFirstResult(first);
            }
            this.iterator = this.page.getResults().iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract IPage<T> getPage(IArchetypeService var1, IArchetypeQuery var2);
}

