/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IConstraintContainer;

public abstract class JoinConstraint
implements IConstraintContainer {
    private static final long serialVersionUID = 1L;
    private JoinType joinType;
    private BaseArchetypeConstraint archetypeConstraint;

    public JoinConstraint(BaseArchetypeConstraint constraint) {
        this(constraint, JoinType.InnerJoin);
    }

    public JoinConstraint(BaseArchetypeConstraint constraint, JoinType join) {
        this.archetypeConstraint = constraint;
        this.joinType = join;
    }

    public BaseArchetypeConstraint getArchetypeConstraint() {
        return this.archetypeConstraint;
    }

    @Override
    public JoinConstraint add(IConstraint constraint) {
        this.archetypeConstraint.add(constraint);
        return this;
    }

    @Override
    public JoinConstraint remove(IConstraint constraint) {
        this.archetypeConstraint.remove(constraint);
        return this;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinConstraint setJoinType(JoinType join) {
        this.joinType = join;
        return this;
    }

    public String getAlias() {
        return this.getArchetypeConstraint().getAlias();
    }

    public void setAlias(String alias) {
        this.getArchetypeConstraint().setAlias(alias);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JoinConstraint)) {
            return false;
        }
        JoinConstraint rhs = (JoinConstraint)obj;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object)this.archetypeConstraint, (Object)rhs.archetypeConstraint).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("archetypeConstraint", (Object)this.archetypeConstraint).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        JoinConstraint copy = (JoinConstraint)super.clone();
        copy.archetypeConstraint = (BaseArchetypeConstraint)this.archetypeConstraint.clone();
        return copy;
    }

    public static enum JoinType {
        InnerJoin,
        LeftOuterJoin,
        RightOuterJoin;

    }
}

