/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.system.common.query.ArchetypeConstraint;
import org.openvpms.component.system.common.query.ArchetypeIdConstraint;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class CollectionNodeConstraint
extends JoinConstraint {
    private final String nodeName;

    public CollectionNodeConstraint(String nodeName, boolean activeOnly) {
        this(nodeName, new ArchetypeConstraint(CollectionNodeConstraint.getUnqualifiedName(nodeName), false, activeOnly));
    }

    public CollectionNodeConstraint(String nodeName) {
        this(nodeName, false);
    }

    public CollectionNodeConstraint(String nodeName, ArchetypeId archetypeId, boolean activeOnly) {
        this(nodeName, new ArchetypeIdConstraint(CollectionNodeConstraint.getUnqualifiedName(nodeName), archetypeId, activeOnly));
    }

    public CollectionNodeConstraint(String nodeName, String shortName, boolean primaryOnly, boolean activeOnly) {
        this(nodeName, new ShortNameConstraint(CollectionNodeConstraint.getUnqualifiedName(nodeName), shortName, primaryOnly, activeOnly));
    }

    public CollectionNodeConstraint(String nodeName, String[] shortNames, boolean primaryOnly, boolean activeOnly) {
        this(nodeName, new ShortNameConstraint(CollectionNodeConstraint.getUnqualifiedName(nodeName), shortNames, primaryOnly, activeOnly));
    }

    public CollectionNodeConstraint(String nodeName, BaseArchetypeConstraint constraint) {
        super(constraint);
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyNodeName);
        }
        if (constraint.getAlias() == null) {
            this.setAlias(CollectionNodeConstraint.getUnqualifiedName(nodeName));
        }
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getUnqualifiedName() {
        return CollectionNodeConstraint.getUnqualifiedName(this.nodeName);
    }

    @Override
    public CollectionNodeConstraint add(IConstraint constraint) {
        super.add(constraint);
        return this;
    }

    @Override
    public CollectionNodeConstraint remove(IConstraint constraint) {
        super.remove(constraint);
        return this;
    }

    private static String getUnqualifiedName(String nodeName) {
        int index = nodeName.indexOf(".");
        return index != -1 ? nodeName.substring(index + 1) : nodeName;
    }
}

