/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.AbstractArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeIdConstraint;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IConstraintContainer;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class ArchetypeQuery
extends AbstractArchetypeQuery
implements IConstraintContainer {
    private static final long serialVersionUID = 1L;
    private boolean distinct;
    private boolean activeOnly = false;
    private BaseArchetypeConstraint archetypeConstraint;

    public ArchetypeQuery(BaseArchetypeConstraint constraint) {
        try {
            this.archetypeConstraint = (BaseArchetypeConstraint)constraint.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.CloneNotSupported, exception, constraint.getClass());
        }
    }

    public ArchetypeQuery(ArchetypeId archetypeId) {
        this(archetypeId, false);
    }

    public ArchetypeQuery(ArchetypeId archetypeId, boolean activeOnly) {
        this.archetypeConstraint = new ArchetypeIdConstraint(archetypeId, activeOnly);
    }

    public ArchetypeQuery(String entityName, String conceptName, boolean primaryOnly, boolean activeOnly) {
        StringBuilder shortName = new StringBuilder();
        if (entityName != null) {
            shortName.append(entityName);
        } else {
            shortName.append("*");
        }
        shortName.append(".");
        if (conceptName != null) {
            shortName.append(conceptName);
        } else {
            shortName.append("*");
        }
        this.archetypeConstraint = new ShortNameConstraint(shortName.toString(), primaryOnly, activeOnly);
    }

    public ArchetypeQuery(String shortName) {
        this(shortName, false);
    }

    public ArchetypeQuery(String shortName, boolean activeOnly) {
        this(shortName, false, activeOnly);
    }

    public ArchetypeQuery(String shortName, boolean primaryOnly, boolean activeOnly) {
        this.archetypeConstraint = new ShortNameConstraint(shortName, primaryOnly, activeOnly);
    }

    public ArchetypeQuery(List<String> shortNames, boolean primaryOnly, boolean activeOnly) {
        this.archetypeConstraint = new ShortNameConstraint(shortNames, primaryOnly, activeOnly);
    }

    public ArchetypeQuery(String[] shortNames, boolean primaryOnly, boolean activeOnly) {
        this.archetypeConstraint = new ShortNameConstraint(shortNames, primaryOnly, activeOnly);
    }

    public ArchetypeQuery(Reference reference) {
        this.archetypeConstraint = new ObjectRefConstraint(reference);
    }

    @Override
    public ArchetypeQuery setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        return this;
    }

    @Override
    public ArchetypeQuery setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public ArchetypeQuery setCountResults(boolean count) {
        super.setCountResults(count);
        return this;
    }

    public boolean isActiveOnly() {
        return this.activeOnly;
    }

    public ArchetypeQuery setActiveOnly(boolean activeOnly) {
        this.activeOnly = activeOnly;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public ArchetypeQuery setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public BaseArchetypeConstraint getArchetypeConstraint() {
        return this.archetypeConstraint;
    }

    @Override
    public ArchetypeQuery add(IConstraint constraint) {
        this.archetypeConstraint.add(constraint);
        return this;
    }

    @Override
    public ArchetypeQuery remove(IConstraint constraint) {
        this.archetypeConstraint.remove(constraint);
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("constraints", (Object)this.archetypeConstraint).toString();
    }
}

