/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.RelationalOp;

public abstract class AbstractNodeConstraint
implements IConstraint {
    private static final long serialVersionUID = 1L;
    private String alias;
    private String nodeName;
    private RelationalOp operator;
    private Object[] parameters;

    AbstractNodeConstraint(String nodeName, RelationalOp operator, Object[] parameters) {
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyNodeName);
        }
        int index = nodeName.indexOf(".");
        if (index != -1) {
            this.alias = nodeName.substring(0, index);
            this.nodeName = nodeName.substring(index + 1);
        } else {
            this.nodeName = nodeName;
        }
        if (operator == null) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyOperator);
        }
        this.operator = operator;
        int size = parameters != null ? parameters.length : 0;
        int expected = operator.getParamCount();
        if (operator == RelationalOp.IN && size < 1 || operator != RelationalOp.IN && size != expected) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.ParameterCountMismatch, new Object[]{operator, operator.getParamCount(), size});
        }
        this.parameters = parameters;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public RelationalOp getOperator() {
        return this.operator;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractNodeConstraint)) {
            return false;
        }
        AbstractNodeConstraint rhs = (AbstractNodeConstraint)obj;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object)this.nodeName, (Object)rhs.nodeName).append((Object)this.operator, (Object)rhs.operator).append(this.parameters, rhs.parameters).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("alias", (Object)this.alias).append("nodeName", (Object)this.nodeName).append("operator", (Object)this.operator).append("parameters", this.parameters).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractNodeConstraint copy = (AbstractNodeConstraint)super.clone();
        copy.nodeName = this.nodeName;
        copy.operator = this.operator;
        copy.parameters = new Object[this.parameters.length];
        System.arraycopy(this.parameters, 0, copy.parameters, 0, this.parameters.length);
        return copy;
    }
}

