/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.model.NodePointer;

class TypeConversionUtil {
    TypeConversionUtil() {
    }

    public static BigDecimal bigDecimalValue(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof Number) {
            return BigDecimal.valueOf(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)object != false ? 0L : 1L);
        }
        if (object instanceof String) {
            BigDecimal value = BigDecimal.ZERO;
            if (!object.equals("")) {
                try {
                    value = new BigDecimal((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return value;
        }
        if (object instanceof NodePointer) {
            return TypeConversionUtil.bigDecimalValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            if (ptr != null) {
                return TypeConversionUtil.bigDecimalValue(ptr);
            }
            return BigDecimal.ZERO;
        }
        return TypeConversionUtil.bigDecimalValue(InfoSetUtil.stringValue((Object)object));
    }
}

