/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.math.BigDecimal;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;

public final class MoneyConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public MoneyConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public MoneyConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Money) {
            return value;
        }
        try {
            if (value instanceof String) {
                return new Money((String)value);
            }
            if (value instanceof BigDecimal) {
                return new Money((BigDecimal)value);
            }
            if (value instanceof Double) {
                return new Money((Double)value);
            }
            return new Money(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException((Throwable)e);
        }
    }
}

