/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.util.Map;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.jxpath.util.TypeUtils;
import org.openvpms.component.system.common.jxpath.JXPathHelperException;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.openvpms.component.system.common.jxpath.OpenVPMSContextFactoryReferenceImpl;
import org.openvpms.component.system.common.jxpath.OpenVPMSTypeConverter;

public class JXPathHelper {
    private static FunctionLibrary functions = new FunctionLibrary();

    public JXPathHelper() {
    }

    public JXPathHelper(Map<String, Object> properties) {
        if (properties != null) {
            for (String ns : properties.keySet()) {
                String namespace = ns;
                Object value = properties.get(namespace);
                if (value instanceof String) {
                    this.addFunctions((String)value, namespace);
                    continue;
                }
                this.addFunctions(value, namespace);
            }
        }
    }

    public JXPathHelper(Functions functions) {
        if (functions instanceof FunctionLibrary) {
            JXPathHelper.functions = (FunctionLibrary)functions;
        } else {
            JXPathHelper.functions.addFunctions(functions);
        }
    }

    public static JXPathContext newContext(Object object) {
        return JXPathHelper.newContext(object, (Functions)functions);
    }

    public static JXPathContext newContext(Object object, Functions functions) {
        JXPathContext context = JXPathContext.newContext((Object)object);
        FunctionLibrary lib = new FunctionLibrary();
        lib.addFunctions(context.getFunctions());
        lib.addFunctions(functions);
        context.setFunctions((Functions)lib);
        context.setLenient(true);
        return context;
    }

    private void addFunctions(String className, String namespace) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            functions.addFunctions((Functions)new ClassFunctions(clazz, namespace));
        }
        catch (Exception exception) {
            throw new JXPathHelperException(JXPathHelperException.ErrorCode.InvalidClassSpecified, new Object[]{className}, exception);
        }
    }

    private void addFunctions(Object functionObject, String namespace) {
        if (functionObject instanceof Functions) {
            functions.addFunctions((Functions)functionObject);
        } else {
            functions.addFunctions((Functions)new ObjectFunctions(functionObject, namespace));
        }
    }

    static {
        System.setProperty("org.apache.commons.jxpath.JXPathContextFactory", OpenVPMSContextFactoryReferenceImpl.class.getName());
        TypeUtils.setTypeConverter((TypeConverter)new OpenVPMSTypeConverter());
        functions.addFunctions(JXPathContext.newContext((Object)new Object()).getFunctions());
    }
}

