/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.event;

import java.util.concurrent.ThreadPoolExecutor;
import org.openvpms.component.system.common.event.AbstractListeners;
import org.openvpms.component.system.common.event.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncListeners<E>
extends AbstractListeners<E> {
    private final ThreadPoolExecutor executor;
    private static final Logger log = LoggerFactory.getLogger(AsyncListeners.class);

    public AsyncListeners(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    protected void notify(final Listener<E> listener, final E event) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    listener.onEvent(event);
                }
                catch (Throwable exception) {
                    AsyncListeners.this.onException(listener, exception);
                }
            }
        });
    }

    protected void onException(Listener<E> listener, Throwable exception) {
        log.error("Listener " + listener + " terminated with exception: " + exception.getMessage(), exception);
    }
}

