/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.event;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.system.common.event.Listener;
import org.openvpms.component.system.common.event.Listeners;

public abstract class AbstractListeners<E>
implements Listeners<E> {
    private List<Listener<E>> listeners = new ArrayList<Listener<E>>();

    @Override
    public synchronized void addListener(Listener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(Listener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void clear() {
        this.listeners.clear();
    }

    @Override
    public void onEvent(E event) {
        Listener<E>[] list;
        for (Listener<E> listener : list = this.getListeners()) {
            this.notify(listener, event);
        }
    }

    protected synchronized Listener<E>[] getListeners() {
        return this.listeners.toArray(new Listener[this.listeners.size()]);
    }

    protected abstract void notify(Listener<E> var1, E var2);
}

