/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.crypto;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.keygen.KeyGenerators;

public class KeyGenerator {
    public static String generate(int minLength, int maxLength) {
        SecureRandom random = new SecureRandom();
        int count = minLength == maxLength ? maxLength : random.nextInt(maxLength - minLength) + minLength;
        String password = RandomStringUtils.random((int)count, (int)33, (int)126, (boolean)false, (boolean)false, null, (Random)random);
        byte[] salt = KeyGenerators.secureRandom((int)16).generateKey();
        String key = KeyGenerator.encode64(salt) + ":" + password;
        return KeyGenerator.encode64(key);
    }

    public static String[] decode(String key) {
        String decoded = KeyGenerator.decode64(key);
        int index = decoded.indexOf(58);
        if (index == -1) {
            throw new IllegalStateException("Invalid key");
        }
        String salt = decoded.substring(0, index);
        String hex = new String(Hex.encode((byte[])Base64.getDecoder().decode(salt)));
        String password = decoded.substring(index + 1);
        return new String[]{hex, password};
    }

    private static String encode64(String string) {
        return KeyGenerator.encode64(string.getBytes(StandardCharsets.UTF_8));
    }

    private static String encode64(byte[] bytes) {
        return Base64.getEncoder().withoutPadding().encodeToString(bytes);
    }

    private static String decode64(String string) {
        return new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
    }
}

