/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.crypto;

import java.util.Base64;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.crypto.encrypt.BytesEncryptor;

public class Base64EncodingPasswordEncryptor
implements PasswordEncryptor {
    private final BytesEncryptor bytesEncryptor;

    public Base64EncodingPasswordEncryptor(BytesEncryptor bytesEncryptor) {
        this.bytesEncryptor = bytesEncryptor;
    }

    public String encrypt(String password) {
        return Base64.getEncoder().withoutPadding().encodeToString(this.bytesEncryptor.encrypt(Utf8.encode((CharSequence)password)));
    }

    public String decrypt(String encryptedPassword) {
        return Utf8.decode((byte[])this.bytesEncryptor.decrypt(Base64.getDecoder().decode(encryptedPassword)));
    }
}

