/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.singleton;

import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class SingletonQuery {
    private final ArchetypeService service;

    public SingletonQuery(ArchetypeService service) {
        this.service = service;
    }

    public boolean exists(String archetype) {
        return this.exists(archetype, null);
    }

    public boolean exists(String archetype, Reference exclude) {
        Class type = this.getType(archetype);
        Query query = new Query(archetype, type, Long.class, exclude);
        query.select("id");
        return query.get() != null;
    }

    public <T extends IMObject> T get(String archetype, Class<T> type) {
        Query<T, T> query = new Query<T, T>(archetype, type, type);
        return (T)((IMObject)query.get());
    }

    private <T extends IMObject> Class<T> getType(String archetype) {
        ArchetypeDescriptor descriptor = this.service.getArchetypeDescriptor(archetype);
        if (descriptor == null) {
            throw new IllegalStateException("Unable to determine type of archetype: " + archetype);
        }
        return descriptor.getClassType();
    }

    class Query<T extends IMObject, R> {
        private final Root<T> root;
        private final CriteriaQuery<R> query;

        public Query(String archetype, Class<T> type, Class<R> resultType) {
            this(archetype, type, resultType, null);
        }

        public Query(String archetype, Class<T> type, Class<R> resultType, Reference exclude) {
            CriteriaBuilder builder = SingletonQuery.this.service.getCriteriaBuilder();
            this.query = builder.createQuery(resultType);
            this.root = this.query.from(type, new String[]{archetype});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Predicate active = builder.equal((Expression)this.root.get("active"), (Object)true);
            predicates.add(active);
            if (exclude != null && !exclude.isNew()) {
                predicates.add(builder.equal((Expression)this.root.reference(), (Object)exclude).not());
            }
            this.query.where(predicates);
            this.query.orderBy(new Order[]{builder.asc((Expression)this.root.get("id"))});
        }

        public void select(String node) {
            this.query.select((Selection)this.root.get(node));
        }

        public R get() {
            return (R)SingletonQuery.this.service.createQuery(this.query).getFirstResult();
        }
    }
}

