/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.security;

import org.openvpms.component.business.domain.im.security.User;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class UserAuthenticationProvider
extends DaoAuthenticationProvider {
    private final boolean expireOnChangePassword;

    public UserAuthenticationProvider(UserDetailsService userService, PasswordEncoder passwordEncoder, boolean expireOnChangePassword) {
        this.setUserDetailsService(userService);
        this.setPasswordEncoder(passwordEncoder);
        this.expireOnChangePassword = expireOnChangePassword;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        this.checkAuthentication(userDetails);
    }

    protected void checkAuthentication(UserDetails userDetails) {
        User user;
        if (this.expireOnChangePassword && (user = this.getUser(userDetails)) != null && user.getChangePassword()) {
            throw new CredentialsExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.credentialsExpired", "User credentials have expired"));
        }
    }

    protected User getUser(UserDetails userDetails) {
        return userDetails instanceof User ? (User)userDetails : null;
    }
}

