/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.ArchetypeAccessDeniedException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class ArchetypeAccessDecisionManager
implements AccessDecisionManager {
    private static final String ARCHETYPE_PREFIX = "archetypeService";
    private static final Logger log = LoggerFactory.getLogger(ArchetypeAccessDecisionManager.class);

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) throws AccessDeniedException, InsufficientAuthenticationException {
        boolean checked = false;
        String[] archetypes = this.getArchetypes((MethodInvocation)object);
        for (ConfigAttribute attribute : attributes) {
            if (this.supports(attribute)) {
                String method;
                StringTokenizer tokens = new StringTokenizer(attribute.getAttribute(), ".");
                String serviceName = tokens.hasMoreTokens() ? tokens.nextToken() : null;
                String string = method = tokens.hasMoreTokens() ? tokens.nextToken() : null;
                if (serviceName != null && method != null) {
                    this.check(archetypes, authentication, serviceName, method);
                    checked = true;
                    continue;
                }
                throw new AccessDeniedException("Unsupported attribute: " + attribute);
            }
            throw new AccessDeniedException("Unsupported attribute: " + attribute);
        }
        if (!checked) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        String a = attribute.getAttribute();
        return a != null && a.startsWith(ARCHETYPE_PREFIX);
    }

    public boolean supports(Class<?> clazz) {
        return clazz == MethodInvocation.class;
    }

    private void check(String[] archetypes, Authentication authentication, String serviceName, String method) {
        for (String archetype : archetypes) {
            boolean granted = false;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!(authority instanceof ArchetypeAwareGrantedAuthority) || !this.isAccessGranted((ArchetypeAwareGrantedAuthority)authority, archetype, serviceName, method)) continue;
                granted = true;
                break;
            }
            if (granted) continue;
            if (log.isWarnEnabled()) {
                log.warn("Access denied to principal=" + authentication.getPrincipal() + ", operation=" + method + ", archetype=" + archetype);
            }
            throw new ArchetypeAccessDeniedException(archetype, method);
        }
    }

    private boolean isAccessGranted(ArchetypeAwareGrantedAuthority authority, String archetype, String serviceName, String method) {
        if (!serviceName.equals(authority.getServiceName())) {
            return false;
        }
        String authMethod = authority.getMethod();
        String authShortName = authority.getShortName();
        return !StringUtils.isEmpty((String)authMethod) && !StringUtils.isEmpty((String)authShortName) && StringUtilities.matches(method, authMethod) && StringUtilities.matches(archetype, authShortName);
    }

    private String[] getArchetypes(MethodInvocation method) {
        String[] result = new String[]{};
        if (method != null) {
            String methodName = method.getMethod().getName();
            Class<?> declaring = method.getMethod().getDeclaringClass();
            if (declaring.equals(IArchetypeService.class)) {
                Object arg = method.getArguments()[0];
                switch (methodName) {
                    case "create": {
                        if (arg instanceof String) {
                            result = new String[]{(String)arg};
                            break;
                        }
                        result = new String[]{((ArchetypeId)arg).getShortName()};
                        break;
                    }
                    case "save": {
                        if (arg instanceof IMObject) {
                            IMObject object = (IMObject)arg;
                            result = new String[]{object.getArchetype()};
                            break;
                        }
                        Collection objects = (Collection)arg;
                        HashSet<String> archetypes = new HashSet<String>();
                        for (IMObject object : objects) {
                            archetypes.add(object.getArchetype());
                        }
                        result = archetypes.toArray(new String[0]);
                        break;
                    }
                    case "remove": {
                        if (arg instanceof IMObject) {
                            result = new String[]{((IMObject)arg).getArchetype()};
                            break;
                        }
                        result = new String[]{((Reference)arg).getArchetype()};
                        break;
                    }
                }
            }
        }
        return result;
    }
}

