/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.scheduler;

import java.util.concurrent.Callable;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.user.User;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.DelegatingJob;

public class JobRunner
implements InterruptableJob {
    private IMObject configuration;
    private IArchetypeService service;
    private ApplicationContext context;
    private Job job;
    private static final Logger log = LoggerFactory.getLogger(JobRunner.class);

    public void setConfiguration(IMObject configuration) {
        this.configuration = configuration;
    }

    public void setArchetypeService(IArchetypeService service) {
        this.service = service;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (this.configuration == null) {
            throw new JobExecutionException("Configuration has not been registered");
        }
        if (this.service == null) {
            throw new JobExecutionException("ArchetypeService has not been registered");
        }
        long start = System.currentTimeMillis();
        log.info("Job " + this.getName(this.configuration) + " - starting");
        org.openvpms.component.business.domain.im.security.User user = this.getUser();
        Callable<Void> callable = () -> {
            this.job = this.createJob();
            this.job.execute(context);
            return null;
        };
        try {
            RunAs.run((User)user, callable);
            long end = System.currentTimeMillis();
            log.info("Job " + this.getName(this.configuration) + " - finished in " + (end - start) + "ms");
        }
        catch (Throwable exception) {
            long end = System.currentTimeMillis();
            log.error("Job " + this.getName(this.configuration) + " - failed in " + (end - start) + "ms", exception);
            if (exception instanceof JobExecutionException) {
                throw (JobExecutionException)exception;
            }
            throw new JobExecutionException(exception);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.job instanceof InterruptableJob) {
            ((InterruptableJob)this.job).interrupt();
        }
    }

    private Job createJob() throws ClassNotFoundException {
        IMObjectBean bean = this.service.getBean(this.configuration);
        Class<?> type = Class.forName(bean.getString("class"));
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory((BeanFactory)this.context);
        factory.registerSingleton("jobConfiguration", (Object)this.configuration);
        Object job = factory.createBean(type, 3, true);
        Object result = job instanceof Runnable ? new DelegatingJob((Runnable)job) : (Job)job;
        return result;
    }

    private org.openvpms.component.business.domain.im.security.User getUser() throws JobExecutionException {
        IMObjectBean bean = this.service.getBean(this.configuration);
        org.openvpms.component.business.domain.im.security.User user = (org.openvpms.component.business.domain.im.security.User)bean.getTarget("runAs");
        if (user == null) {
            throw new JobExecutionException("User not found");
        }
        return user;
    }

    private String getName(IMObject configuration) {
        return configuration != null ? configuration.getName() + " (" + configuration.getId() + ")" : null;
    }
}

