/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.business.service.lookup.ILookupService;
import org.openvpms.component.business.service.lookup.LookupServiceException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;

public abstract class AbstractLookupService
implements ILookupService {
    private final IArchetypeService service;
    private final IMObjectDAO dao;
    private static final String DEFAULT_LOOKUP = "defaultLookup";

    protected AbstractLookupService(IArchetypeService service, IMObjectDAO dao) {
        this.service = service;
        this.dao = dao;
    }

    public Lookup getLookup(String shortName, String code) {
        return this.getLookup(shortName, code, true);
    }

    public Lookup getLookup(String shortName, String code, boolean activeOnly) {
        return this.query(shortName, code, activeOnly);
    }

    public Collection<Lookup> getLookups(String shortName) {
        return this.query(shortName);
    }

    public Lookup getDefaultLookup(String shortName) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, true).add(Constraints.eq(DEFAULT_LOOKUP, true)).setMaxResults(1);
        List<IMObject> results = this.getService().get(query).getResults();
        return !results.isEmpty() ? (Lookup)results.get(0) : null;
    }

    public Collection<Lookup> getSourceLookups(Lookup lookup) {
        return this.getSourceLookups(lookup.getTargetLookupRelationships());
    }

    public Collection<Lookup> getSourceLookups(Lookup lookup, String relationshipShortName) {
        Collection<LookupRelationship> relationships = this.getRelationships(relationshipShortName, lookup.getTargetLookupRelationships());
        return this.getSourceLookups(relationships);
    }

    public Collection<Lookup> getTargetLookups(Lookup lookup) {
        return this.getTargetLookups(lookup.getSourceLookupRelationships());
    }

    public Collection<Lookup> getTargetLookups(Lookup lookup, String relationshipShortName) {
        Collection<LookupRelationship> relationships = this.getRelationships(relationshipShortName, lookup.getSourceLookupRelationships());
        return this.getTargetLookups(relationships);
    }

    public Collection<Lookup> getLookups(String shortName, String node) {
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(shortName);
        if (archetype == null) {
            throw new IllegalArgumentException("Invalid archetype shortname: " + shortName);
        }
        NodeDescriptor descriptor = archetype.getNodeDescriptor(node);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid node name: " + node);
        }
        LookupAssertion assertion = LookupAssertionFactory.create(descriptor, this.service, this);
        return assertion.getLookups();
    }

    public Collection<Lookup> getLookups(org.openvpms.component.model.object.IMObject object, String node) {
        IMObjectBean bean = this.service.getBean(object);
        NodeDescriptor descriptor = (NodeDescriptor)bean.getNode(node);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid node name: " + node);
        }
        LookupAssertion assertion = LookupAssertionFactory.create(descriptor, this.service, this);
        return assertion.getLookups(object);
    }

    public Lookup getLookup(org.openvpms.component.model.object.IMObject object, String node) {
        IMObjectBean bean = this.service.getBean(object);
        return bean.getLookup(node);
    }

    public String getName(org.openvpms.component.model.object.IMObject object, String node) {
        Lookup lookup = this.getLookup(object, node);
        return lookup != null ? lookup.getName() : null;
    }

    @Override
    public Lookup getLookup(String archetype, String node, String code) {
        Collection<Lookup> lookups = this.getLookups(archetype, node);
        for (Lookup lookup : lookups) {
            if (!lookup.getCode().equals(code)) continue;
            return lookup;
        }
        return null;
    }

    @Override
    public String getName(String archetype, String node, String code) {
        Lookup lookup = this.getLookup(archetype, node, code);
        return lookup != null ? lookup.getName() : null;
    }

    @Override
    public void replace(Lookup source, Lookup target) {
        if (!source.getArchetype().equals(target.getArchetype())) {
            throw new LookupServiceException(LookupServiceException.ErrorCode.CannotReplaceArchetypeMismatch);
        }
        this.dao.replace(source, target);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected IMObjectDAO getDAO() {
        return this.dao;
    }

    protected Lookup query(String shortName, String code, boolean activeOnly) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, activeOnly);
        query.add(new NodeConstraint("code", code));
        query.setMaxResults(1);
        List<IMObject> results = this.service.get(query).getResults();
        return !results.isEmpty() ? (Lookup)results.get(0) : null;
    }

    protected Collection<Lookup> query(String shortName) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, true);
        query.setMaxResults(1000);
        query.add(new NodeSortConstraint("id"));
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, query);
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        while (iter.hasNext()) {
            result.add((Lookup)iter.next());
        }
        return result;
    }

    protected Lookup getLookup(Reference reference) {
        return reference != null ? (Lookup)this.service.get(reference) : null;
    }

    private Collection<Lookup> getSourceLookups(Collection<LookupRelationship> relationships) {
        List<Lookup> result;
        if (!relationships.isEmpty()) {
            result = new ArrayList();
            for (LookupRelationship relationship : relationships) {
                Lookup source = this.getLookup(relationship.getSource());
                if (source == null) continue;
                result.add(source);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private Collection<Lookup> getTargetLookups(Collection<LookupRelationship> relationships) {
        List<Lookup> result;
        if (!relationships.isEmpty()) {
            result = new ArrayList();
            for (LookupRelationship relationship : relationships) {
                Lookup target = this.getLookup(relationship.getTarget());
                if (target == null) continue;
                result.add(target);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private Collection<LookupRelationship> getRelationships(String shortName, Collection<LookupRelationship> relationships) {
        List<LookupRelationship> result = null;
        for (LookupRelationship relationship : relationships) {
            if (!TypeHelper.isA((org.openvpms.component.model.object.IMObject)relationship, shortName)) continue;
            if (result == null) {
                result = new ArrayList<LookupRelationship>();
            }
            result.add(relationship);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

