/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.DelegatingArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.ruleengine.IRuleEngine;
import org.openvpms.component.business.service.ruleengine.RuleSetUriHelper;
import org.openvpms.component.model.object.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ArchetypeRuleService
extends DelegatingArchetypeService
implements IArchetypeRuleService {
    private final IRuleEngine rules;
    private final PlatformTransactionManager txnManager;
    private final TransactionTemplate template;
    private List<Object> facts;
    private static final String SAVE = "save";
    private static final String REMOVE = "remove";
    private static final Logger log = LoggerFactory.getLogger(ArchetypeRuleService.class);

    public ArchetypeRuleService(IArchetypeService service, IRuleEngine rules, PlatformTransactionManager txnManager) {
        super(service);
        this.rules = rules;
        this.txnManager = txnManager;
        this.template = new TransactionTemplate(txnManager);
    }

    public void setFacts(List<Object> facts) {
        this.facts = facts;
    }

    @Override
    @Deprecated
    public void save(org.openvpms.component.model.object.IMObject object, boolean validate) {
        this.execute(SAVE, object, () -> this.getService().save(object, validate));
    }

    @Override
    @Deprecated
    public void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects, boolean validate) {
        this.execute(SAVE, objects, () -> this.getService().save(objects, validate));
    }

    @Override
    public void remove(org.openvpms.component.model.object.IMObject object) {
        this.execute(REMOVE, object, () -> this.getService().remove(object));
    }

    @Override
    public void remove(Reference reference) {
        String archetype = reference.getArchetype();
        if (this.rules.hasRules(this.getRuleSetURI(REMOVE, archetype, true)) || this.rules.hasRules(this.getRuleSetURI(REMOVE, archetype, false))) {
            IMObject object = this.get(reference);
            if (object == null) {
                throw new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeleteObject, reference);
            }
            this.remove(object);
        } else {
            this.getService().remove(reference);
        }
    }

    private void execute(String name, org.openvpms.component.model.object.IMObject object, Runnable operation) {
        this.template.execute(status -> {
            this.executeRules(name, object, true);
            operation.run();
            this.executeRules(name, object, false);
            return null;
        });
    }

    private void execute(String name, Collection<? extends org.openvpms.component.model.object.IMObject> objects, Runnable op) {
        this.template.execute(status -> {
            for (org.openvpms.component.model.object.IMObject object : objects) {
                this.executeRules(name, object, true);
            }
            op.run();
            for (org.openvpms.component.model.object.IMObject object : objects) {
                this.executeRules(name, object, false);
            }
            return null;
        });
    }

    private void executeRules(String name, org.openvpms.component.model.object.IMObject object, boolean before) {
        String uri = this.getRuleSetURI(name, object.getArchetype(), before);
        if (this.rules.hasRules(uri)) {
            log.debug("Executing rules for uri={}", (Object)uri);
            ArrayList<Object> localFacts = new ArrayList<Object>();
            localFacts.add(object);
            localFacts.add(this.getService());
            localFacts.add(this.txnManager);
            if (this.facts != null) {
                localFacts.addAll(this.facts);
            }
            this.rules.executeRules(uri, localFacts);
        }
    }

    private String getRuleSetURI(String name, String archetype, boolean before) {
        return RuleSetUriHelper.getRuleSetURI("archetypeService", name, before, archetype);
    }
}

