/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.helper.LookupHelperException;
import org.openvpms.component.business.service.archetype.helper.lookup.AbstractLookupAssertion;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class RemoteLookup
extends AbstractLookupAssertion {
    public static final String TYPE = "lookup";
    private final org.openvpms.component.model.archetype.NodeDescriptor descriptor;
    private final String source;

    public RemoteLookup(org.openvpms.component.model.archetype.NodeDescriptor descriptor, AssertionDescriptor assertion, ArchetypeService service, LookupService lookupService) {
        super(assertion, TYPE, service, lookupService);
        this.descriptor = descriptor;
        this.source = this.getProperty("source");
        if (StringUtils.isEmpty((CharSequence)this.source)) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.SourceNotSpecified, new Object[]{assertion.getName(), TYPE});
        }
    }

    public String getShortName() {
        return this.source;
    }

    @Override
    public List<Lookup> getLookups() {
        Collection lookups = this.getLookupService().getLookups(this.source);
        return new ArrayList<Lookup>(lookups);
    }

    @Override
    public Collection<Lookup> getLookups(org.openvpms.component.model.object.IMObject context) {
        String code;
        Collection<Lookup> lookups = super.getLookups(context);
        NodeDescriptor d = (NodeDescriptor)this.descriptor;
        Object value = d.getValue((IMObject)context);
        String string = code = value instanceof String ? (String)value : null;
        if (code != null) {
            Lookup lookup;
            boolean found = false;
            for (Lookup lookup2 : lookups) {
                if (!code.equals(lookup2.getCode())) continue;
                found = true;
                break;
            }
            if (!found && (lookup = this.getLookup(code)) != null) {
                lookups.add(lookup);
            }
        }
        return lookups;
    }

    @Override
    public Lookup getLookup(String code) {
        return this.getLookupService().getLookup(this.source, code, false);
    }

    @Override
    public Lookup getDefault() {
        return this.getLookupService().getDefaultLookup(this.source);
    }
}

