/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.lookup;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.LookupHelperException;
import org.openvpms.component.business.service.archetype.helper.lookup.LocalLookup;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionHelper;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionType;
import org.openvpms.component.business.service.archetype.helper.lookup.RemoteLookup;
import org.openvpms.component.business.service.archetype.helper.lookup.SourceLookup;
import org.openvpms.component.business.service.archetype.helper.lookup.TargetLookup;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class LookupAssertionFactory {
    private LookupAssertionFactory() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookupAssertion create(NodeDescriptor descriptor, ArchetypeService service, LookupService lookupService) {
        void var3_13;
        if (descriptor.containsAssertionType("lookup")) {
            AssertionDescriptor assertion = descriptor.getAssertionDescriptor("lookup");
            String type = LookupAssertionHelper.getValue(assertion, "type");
            if (StringUtils.isEmpty((CharSequence)type)) {
                throw new LookupHelperException(LookupHelperException.ErrorCode.TypeNotSpecified, new Object[]{assertion.getName()});
            }
            if ("lookup".equals(type)) {
                RemoteLookup remoteLookup = new RemoteLookup(descriptor, assertion, service, lookupService);
                return var3_13;
            } else if ("targetLookup".equals(type)) {
                TargetLookup targetLookup = new TargetLookup(assertion, service, lookupService);
                return var3_13;
            } else {
                if (!"sourceLookup".equals(type)) throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupType, new Object[]{type});
                SourceLookup sourceLookup = new SourceLookup(assertion, service, lookupService);
            }
            return var3_13;
        } else if (descriptor.containsAssertionType("lookup.local")) {
            AssertionDescriptor assertion = descriptor.getAssertionDescriptor("lookup.local");
            LocalLookup localLookup = new LocalLookup(assertion, service, lookupService);
            return var3_13;
        } else {
            if (!descriptor.containsAssertionType("lookup.assertionType")) throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupAssertion, new Object[]{descriptor.getName()});
            AssertionDescriptor assertion = descriptor.getAssertionDescriptor("lookup.assertionType");
            LookupAssertionType lookupAssertionType = new LookupAssertionType(assertion, service, lookupService);
        }
        return var3_13;
    }
}

