/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.PropertySetResolver;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.AbstractPropertySet;
import org.openvpms.component.system.common.util.MapPropertySet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.component.system.common.util.PropertyState;

public class ResolvingPropertySet
extends AbstractPropertySet {
    private final PropertySet properties;
    private final ArchetypeService service;
    private final LookupService lookups;
    private PropertyResolver resolver;

    public ResolvingPropertySet(ArchetypeService service, LookupService lookups) {
        this(new HashMap<String, Object>(), service, lookups);
    }

    public ResolvingPropertySet(Map<String, Object> properties, ArchetypeService service, LookupService lookups) {
        this.properties = new MapPropertySet(properties);
        this.service = service;
        this.lookups = lookups;
    }

    @Override
    public boolean exists(String name) {
        boolean exists = this.properties.exists(name);
        if (!exists) {
            try {
                this.getResolver().resolve(name);
                exists = true;
            }
            catch (PropertyResolverException propertyResolverException) {
                // empty catch block
            }
        }
        return exists;
    }

    @Override
    public Set<String> getNames() {
        return this.properties.getNames();
    }

    @Override
    public Object get(String name) {
        return this.resolve(name).getValue();
    }

    @Override
    public void set(String name, Object value) {
        this.properties.set(name, value);
    }

    @Override
    public PropertyState resolve(String name) {
        return this.getResolver().resolve(name);
    }

    protected PropertyResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = this.createResolver(this.properties, this.service);
        }
        return this.resolver;
    }

    protected PropertyResolver createResolver(PropertySet properties, ArchetypeService service) {
        return new PropertySetResolver(properties, service, this.lookups);
    }
}

