/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.dao.hibernate.im.query.TypeSet;
import org.openvpms.component.business.service.archetype.helper.DefaultRelatedObjectPolicyBuilder;
import org.openvpms.component.business.service.archetype.helper.ObjectRelationshipImpl;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.Order;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.bean.RelatedObjectPolicyBuilder;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class RelatedIMObjectsImpl<T extends IMObject, R extends Relationship>
implements RelatedIMObjects<T, R> {
    private final Collection<R> relationships;
    private final Function<R, Reference> accessor;
    private final BiFunction<Reference, Policy.State, T> resolver;
    private final Policy<R> policy;
    private final ArchetypeService service;

    public RelatedIMObjectsImpl(IMObject object, Collection<R> relationships, Class<T> type, ArchetypeService service) {
        this(relationships, RelatedIMObjectsImpl.getAccessor(object.getObjectReference()), RelatedIMObjectsImpl.getResolver(service, type), service);
    }

    public RelatedIMObjectsImpl(Collection<R> relationships, Class<T> type, boolean source, ArchetypeService service, Policy<R> policy) {
        this(relationships, RelatedIMObjectsImpl.getAccessor(source), RelatedIMObjectsImpl.getResolver(service, type), policy, service);
    }

    public RelatedIMObjectsImpl(Collection<R> relationships, Function<R, Reference> accessor, BiFunction<Reference, Policy.State, T> resolver, ArchetypeService service) {
        this(relationships, accessor, resolver, null, service);
    }

    public RelatedIMObjectsImpl(Collection<R> relationships, Function<R, Reference> accessor, BiFunction<Reference, Policy.State, T> resolver, Policy<R> policy, ArchetypeService service) {
        this.relationships = relationships;
        this.accessor = accessor;
        this.resolver = resolver;
        this.policy = policy;
        this.service = service;
    }

    public RelatedIMObjects<T, R> all() {
        return this.policy((Policy<R>)Policies.all());
    }

    public RelatedIMObjects<T, R> active() {
        return this.policy((Policy<R>)Policies.active());
    }

    public RelatedIMObjects<T, R> active(Date time) {
        return this.policy((Policy<R>)Policies.active((Date)time));
    }

    public RelatedIMObjects<T, R> policy(Policy<R> policy) {
        return this.hasPolicy(policy) ? this : this.newInstance(this.relationships, this.accessor, this.resolver, policy, this.service);
    }

    public RelatedObjectPolicyBuilder<T, R, RelatedIMObjects<T, R>> newPolicy() {
        return new DefaultRelatedObjectPolicyBuilder(this, Relationship.class);
    }

    public T getObject() {
        ObjectRelationship<T, R> result = this.getObjectRelationship();
        return (T)(result != null ? (IMObject)result.getObject() : null);
    }

    public ObjectRelationship<T, R> getObjectRelationship() {
        ObjectRelationshipImpl<IMObject, Relationship> result = null;
        Policy.State state = this.getState();
        for (Relationship relationship : this.getRelationships()) {
            IMObject object;
            Reference reference = this.accessor.apply(relationship);
            if (reference == null || (object = (IMObject)this.resolver.apply(reference, state)) == null) continue;
            if (object.isActive() || state == Policy.State.INACTIVE) {
                result = new ObjectRelationshipImpl<IMObject, Relationship>(object, relationship);
                break;
            }
            if (result != null) continue;
            result = new ObjectRelationshipImpl<IMObject, Relationship>(object, relationship);
        }
        return result;
    }

    public Iterable<T> getObjects() {
        List<Reference> references = this.getReferences();
        return () -> new LazyObjectIterator(references.iterator());
    }

    public Iterable<T> getObjects(int firstResult, int maxResults) {
        Comparator comparator;
        List<Reference> references = this.getReferences();
        Comparator comparator2 = comparator = this.policy != null ? this.policy.getComparator() : null;
        if (comparator == null) {
            references.sort((o1, o2) -> {
                int result = Long.compare(o1.getId(), o2.getId());
                if (result == 0) {
                    result = StringUtils.compare((String)o1.getLinkId(), (String)o2.getLinkId());
                }
                return result;
            });
        }
        return new PagingReferenceIterable(references, this.getState(), firstResult, maxResults);
    }

    public Iterable<T> getObjects(int firstResult, int maxResults, Order ... order) {
        SortableIterable result = order.length == 0 ? this.getObjects(firstResult, maxResults) : new SortableIterable(this.getReferences(), this.getState(), firstResult, maxResults, order);
        return result;
    }

    public Iterable<ObjectRelationship<T, R>> getObjectRelationships() {
        List<R> relationships = this.getRelationships();
        return () -> new LazyRelationshipIterator(relationships.iterator());
    }

    public Iterable<ObjectRelationship<T, R>> getObjectRelationships(int firstResult, int maxResults) {
        Comparator comparator;
        List<R> relationships = this.getRelationships();
        Comparator comparator2 = comparator = this.policy != null ? this.policy.getComparator() : null;
        if (comparator == null) {
            relationships.sort((o1, o2) -> {
                int result = Long.compare(o1.getId(), o2.getId());
                if (result == 0) {
                    result = StringUtils.compare((String)o1.getLinkId(), (String)o2.getLinkId());
                }
                return result;
            });
        }
        return new PagingObjectRelationIterable(relationships, firstResult, maxResults, this.getState());
    }

    public List<R> getRelationships() {
        java.util.function.Predicate predicate;
        ArrayList<Object> result = new ArrayList();
        java.util.function.Predicate predicate2 = predicate = this.policy != null ? this.policy.getPredicate() : null;
        if (predicate == null) {
            result = new ArrayList<R>(this.relationships);
        } else {
            for (Relationship relationship : this.relationships) {
                if (!predicate.test(relationship)) continue;
                result.add(relationship);
            }
        }
        if (!result.isEmpty()) {
            Comparator comparator;
            Comparator comparator2 = comparator = this.policy != null ? this.policy.getComparator() : null;
            if (comparator != null) {
                result.sort(comparator);
            }
        }
        return result;
    }

    public List<Reference> getReferences() {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (Relationship relationship : this.getRelationships()) {
            Reference reference = this.accessor.apply(relationship);
            if (reference == null) continue;
            result.add(reference);
        }
        return result;
    }

    public Policy<R> getPolicy() {
        return this.policy;
    }

    public boolean hasPolicy(Policy<R> policy) {
        return Objects.equals(this.policy, policy) || this.isAll(this.policy) && this.isAll(policy);
    }

    protected RelatedIMObjectsImpl<T, R> newInstance(Collection<R> relationships, Function<R, Reference> accessor, BiFunction<Reference, Policy.State, T> resolver, Policy<R> policy, ArchetypeService service) {
        return new RelatedIMObjectsImpl<T, R>(relationships, accessor, resolver, policy, service);
    }

    private boolean isAll(Policy<R> policy) {
        return policy == null || Objects.equals(policy, Policies.all());
    }

    private static <T extends IMObject> BiFunction<Reference, Policy.State, T> getResolver(ArchetypeService service, Class<T> type) {
        return (reference, state) -> (IMObject)type.cast(RelatedIMObjectsImpl.resolve(reference, state, service));
    }

    private Policy.State getState() {
        return this.policy != null ? this.policy.getState() : Policy.State.ANY;
    }

    private static IMObject resolve(Reference reference, Policy.State state, ArchetypeService service) {
        IMObject result = null;
        if (reference != null) {
            if (state == Policy.State.ANY) {
                result = service.get(reference);
            } else {
                boolean active = state == Policy.State.ACTIVE;
                result = service.get(reference, active);
            }
        }
        return result;
    }

    private static <R extends Relationship> Function<R, Reference> getAccessor(boolean source) {
        return source ? Relationship::getSource : Relationship::getTarget;
    }

    private static <R extends Relationship> Function<R, Reference> getAccessor(Reference reference) {
        return relationship -> {
            Reference target = relationship.getTarget();
            Reference related = null;
            if (target != null && !target.equals((Object)reference)) {
                related = target;
            } else {
                Reference source = relationship.getSource();
                if (source != null && !source.equals((Object)reference)) {
                    related = source;
                }
            }
            return related;
        };
    }

    private List<T> fetch(Collection<Reference> references, Policy.State state) {
        TypedQuery<? extends IMObject> query = this.newQuery(references, state).build();
        return new ArrayList(query.getResultList());
    }

    private QueryBuilder newQuery(Collection<Reference> references, Policy.State state) {
        Set archetypes = references.stream().map(Reference::getArchetype).collect(Collectors.toSet());
        Set<ArchetypeDescriptor> descriptors = archetypes.stream().map(arg_0 -> ((ArchetypeService)this.service).getArchetypeDescriptor(arg_0)).collect(Collectors.toSet());
        Class<?> type = TypeSet.getClass(descriptors);
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root from = query.from(type, archetypes);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        List ids = references.stream().map(Reference::getId).collect(Collectors.toList());
        predicates.add(from.get("id").in(ids));
        if (state != Policy.State.ANY) {
            boolean active = state == Policy.State.ACTIVE;
            predicates.add(builder.equal((Expression)from.get("active"), (Object)active));
        }
        query.where(predicates);
        return new QueryBuilder((CriteriaQuery<? extends IMObject>)query, (Root<? extends IMObject>)from, builder);
    }

    private static abstract class AdaptingIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> iterator;
        private B next;

        protected AdaptingIterator(Iterator<A> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.resolve();
            }
            return this.next != null;
        }

        @Override
        public B next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            B result = this.next;
            this.next = null;
            return result;
        }

        abstract B adapt(A var1);

        private B resolve() {
            while (this.next == null && this.iterator.hasNext()) {
                this.next = this.adapt(this.iterator.next());
            }
            return this.next;
        }
    }

    private static abstract class PagingIterable<X, Y>
    implements Iterable<Y> {
        private final List<X> list;
        private final int firstResult;
        private final int maxResults;
        private final Policy.State state;

        public PagingIterable(List<X> list, int firstResult, int maxResults, Policy.State state) {
            this.list = list;
            this.state = state;
            this.firstResult = firstResult;
            this.maxResults = maxResults;
            if (maxResults < 1) {
                throw new IllegalArgumentException("Argument 'maxResults' must be positive");
            }
        }

        @Override
        public Iterator<Y> iterator() {
            ArrayList<Y> result = new ArrayList<Y>();
            int size = this.list.size();
            int first = this.firstResult;
            int read = 0;
            while (first < size && read < this.maxResults) {
                int last = first + (this.maxResults - read);
                if (last > size) {
                    last = size;
                }
                if (last <= first) continue;
                List<X> subList = this.list.subList(first, last);
                result.addAll(this.query(subList, this.state));
                read = result.size();
                first = last;
            }
            return result.iterator();
        }

        protected abstract List<Y> query(List<X> var1, Policy.State var2);
    }

    private class SortableIterable
    implements Iterable<T> {
        private final List<Reference> list;
        private final int firstResult;
        private final int maxResults;
        private final Policy.State state;
        private final Order[] order;

        public SortableIterable(List<Reference> list, Policy.State state, int firstResult, int maxResults, Order ... order) {
            if (maxResults < 1) {
                throw new IllegalArgumentException("Argument 'maxResults' must be positive");
            }
            this.list = list;
            this.state = state;
            this.firstResult = firstResult;
            this.maxResults = maxResults;
            this.order = order;
        }

        @Override
        public Iterator<T> iterator() {
            TypedQuery<? extends IMObject> query = RelatedIMObjectsImpl.this.newQuery(this.list, this.state).orderBy(this.order).build();
            List results = query.setFirstResult(this.firstResult).setMaxResults(this.maxResults).getResultList();
            return results.iterator();
        }
    }

    private class PagingObjectRelationIterable
    extends PagingIterable<R, ObjectRelationship<T, R>> {
        public PagingObjectRelationIterable(List<R> list, int firstResult, int maxResults, Policy.State state) {
            super(list, firstResult, maxResults, state);
        }

        @Override
        protected List<ObjectRelationship<T, R>> query(List<R> list, Policy.State state) {
            ArrayList result = new ArrayList();
            Set references = list.stream().map(RelatedIMObjectsImpl.this.accessor).collect(Collectors.toSet());
            HashMap matches = new HashMap();
            List objects = RelatedIMObjectsImpl.this.fetch(references, state);
            objects.forEach(object -> matches.put(object.getObjectReference(), object));
            for (Relationship relationship : list) {
                IMObject match = (IMObject)matches.get(RelatedIMObjectsImpl.this.accessor.apply(relationship));
                if (match == null) continue;
                result.add(new ObjectRelationshipImpl<IMObject, Relationship>(match, relationship));
            }
            return result;
        }
    }

    private class PagingReferenceIterable
    extends PagingIterable<Reference, T> {
        public PagingReferenceIterable(List<Reference> references, Policy.State state, int firstResult, int maxResults) {
            super(references, firstResult, maxResults, state);
        }

        @Override
        protected List<T> query(List<Reference> list, Policy.State state) {
            return RelatedIMObjectsImpl.this.fetch(list, state);
        }
    }

    private class LazyObjectIterator
    extends AdaptingIterator<Reference, T> {
        public LazyObjectIterator(Iterator<Reference> references) {
            super(references);
        }

        @Override
        T adapt(Reference object) {
            return (IMObject)RelatedIMObjectsImpl.this.resolver.apply(object, RelatedIMObjectsImpl.this.getState());
        }
    }

    private class LazyRelationshipIterator
    extends AdaptingIterator<R, ObjectRelationship<T, R>> {
        public LazyRelationshipIterator(Iterator<R> iterator) {
            super(iterator);
        }

        @Override
        ObjectRelationship<T, R> adapt(R relationship) {
            Reference reference = (Reference)RelatedIMObjectsImpl.this.accessor.apply(relationship);
            IMObject object = reference != null ? (IMObject)RelatedIMObjectsImpl.this.resolver.apply(reference, RelatedIMObjectsImpl.this.getState()) : null;
            return object != null ? new ObjectRelationshipImpl(object, relationship) : null;
        }
    }

    private class QueryBuilder {
        private final CriteriaQuery<? extends IMObject> query;
        private final Root<? extends IMObject> from;
        private final CriteriaBuilder builder;

        public QueryBuilder(CriteriaQuery<? extends IMObject> query, Root<? extends IMObject> from, CriteriaBuilder builder) {
            this.query = query;
            this.from = from;
            this.builder = builder;
        }

        public QueryBuilder orderBy(Order ... orderBy) {
            ArrayList<Order> list = new ArrayList<Order>(Arrays.asList(orderBy));
            if (list.stream().noneMatch(order -> "id".equals(order.getName()))) {
                list.add(Order.ascending((String)"id"));
            }
            ArrayList<javax.persistence.criteria.Order> criteria = new ArrayList<javax.persistence.criteria.Order>();
            for (Order order2 : list) {
                Path expression = this.from.get(order2.getName());
                criteria.add(order2.isAscending() ? this.builder.asc((Expression)expression) : this.builder.desc((Expression)expression));
            }
            this.query.orderBy(criteria);
            return this;
        }

        public TypedQuery<? extends IMObject> build() {
            return RelatedIMObjectsImpl.this.service.createQuery(this.query);
        }
    }
}

