/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.LookupHelperException;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionHelper;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertyState;

public class LookupHelper {
    private LookupHelper() {
    }

    public static List<Lookup> get(ArchetypeService service, LookupService lookups, NodeDescriptor descriptor) {
        LookupAssertion assertion = LookupAssertionFactory.create(descriptor, service, lookups);
        return assertion.getLookups();
    }

    public static Collection<Lookup> get(ArchetypeService service, LookupService lookups, NodeDescriptor descriptor, IMObject object) {
        LookupAssertion assertion = LookupAssertionFactory.create(descriptor, service, lookups);
        return assertion.getLookups(object);
    }

    public static String getName(ArchetypeService service, LookupService lookupService, IMObject object, String node) {
        NodeResolver resolver = new NodeResolver(object, service, lookupService);
        PropertyState state = resolver.resolve(node);
        NodeDescriptor descriptor = state.getNode();
        if (descriptor == null) {
            throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, node);
        }
        return LookupHelper.getName(service, lookupService, descriptor, state.getParent());
    }

    public static String getName(ArchetypeService service, LookupService lookupService, NodeDescriptor descriptor, IMObject object) {
        String result = null;
        if (!descriptor.isLookup()) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupAssertion, new Object[]{descriptor.getName()});
        }
        Object value = descriptor.getValue(object);
        if (value != null) {
            LookupAssertion assertion = LookupAssertionFactory.create(descriptor, service, lookupService);
            result = assertion.getName(object, (String)value);
        }
        return result;
    }

    public static Map<String, String> getNames(IArchetypeService service, LookupService lookupService, String shortName, String node) {
        NodeDescriptor descriptor;
        ArchetypeDescriptor archetype = service.getArchetypeDescriptor(shortName);
        if (archetype != null && (descriptor = archetype.getNodeDescriptor(node)) != null) {
            return LookupHelper.getNames(service, lookupService, descriptor);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getNames(IArchetypeService service, LookupService lookupService, NodeDescriptor descriptor) {
        HashMap<String, String> result = new HashMap<String, String>();
        LookupAssertion assertion = LookupAssertionFactory.create(descriptor, service, lookupService);
        List<Lookup> lookups = assertion.getLookups();
        for (Lookup lookup : lookups) {
            if (!lookup.isActive()) continue;
            result.put(lookup.getCode(), lookup.getName());
        }
        return result;
    }

    public static Map<String, String> getNames(LookupService lookups, String archetype) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Lookup lookup : lookups.getLookups(archetype)) {
            result.put(lookup.getCode(), lookup.getName());
        }
        return result;
    }

    public static String getUnspecifiedValue(NodeDescriptor ndesc) {
        AssertionDescriptor assertion;
        String value = null;
        if (ndesc != null && (assertion = ndesc.getAssertionDescriptor("lookup")) != null) {
            value = LookupAssertionHelper.getValue(assertion, "unspecified");
        }
        return value;
    }
}

