/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.openvpms.component.business.service.archetype.helper.AbstractIMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class IMObjectCopierBuilder {
    private final ArchetypeService service;
    private final State state = new State();

    public IMObjectCopierBuilder(ArchetypeService service) {
        this.service = service;
        this.excludeByDefault();
    }

    public IMObjectCopierBuilder exclude(IMObject ... objects) {
        return this.exclude(this.getReferences(objects));
    }

    public IMObjectCopierBuilder exclude(Reference ... references) {
        return this.add(this.state.objectsToExclude, references);
    }

    public IMObjectCopierBuilder map(String archetypeFrom, String archetypeTo) {
        this.checkWildcard(archetypeFrom, "archetypeFrom");
        this.checkWildcard(archetypeTo, "archetypeTo");
        this.state.map.add(Pair.of((Object)archetypeFrom, (Object)archetypeTo));
        return this;
    }

    public IMObjectCopierBuilder map(String[][] archetypes) {
        return this.map(archetypes, false);
    }

    public IMObjectCopierBuilder map(String[][] archetypes, boolean reverse) {
        for (String[] pair : archetypes) {
            String to;
            String from;
            if (reverse) {
                from = pair[1];
                to = pair[0];
            } else {
                from = pair[0];
                to = pair[1];
            }
            if (from == null) continue;
            this.map(from, to);
        }
        return this;
    }

    public IMObjectCopierBuilder reference(IMObject ... objects) {
        return this.reference(this.getReferences(objects));
    }

    public IMObjectCopierBuilder reference(Reference ... references) {
        return this.add(this.state.objectsToReference, references);
    }

    public IMObjectCopierBuilder copy(IMObject ... objects) {
        return this.copy(this.getReferences(objects));
    }

    public IMObjectCopierBuilder copy(Reference ... references) {
        return this.add(this.state.objectsToCopy, references);
    }

    public IMObjectCopierBuilder exclude(String ... archetypes) {
        return this.add(this.state.archetypesToExclude, archetypes);
    }

    public IMObjectCopierBuilder reference(String ... archetypes) {
        return this.add(this.state.archetypesToReference, archetypes);
    }

    public IMObjectCopierBuilder copy(String ... archetypes) {
        return this.add(this.state.archetypesToCopy, archetypes);
    }

    @SafeVarargs
    public final IMObjectCopierBuilder exclude(Class<? extends IMObject> ... types) {
        this.state.typesToExclude.add(types);
        return this;
    }

    @SafeVarargs
    public final IMObjectCopierBuilder reference(Class<? extends IMObject> ... types) {
        this.state.typesToReference.add(types);
        return this;
    }

    @SafeVarargs
    public final IMObjectCopierBuilder copy(Class<? extends IMObject> ... types) {
        this.state.typesToCopy.add(types);
        return this;
    }

    public IMObjectCopierBuilder referenceByDefault() {
        this.state.defaultTreatment = Treatment.REFERENCE;
        return this;
    }

    public IMObjectCopierBuilder excludeByDefault() {
        this.state.defaultTreatment = Treatment.EXCLUDE;
        return this;
    }

    public IMObjectCopier build() {
        return new IMObjectCopier(new Handler(this.state), this.service);
    }

    private IMObjectCopierBuilder add(Set<Reference> set, Reference ... references) {
        set.addAll(Arrays.asList(references));
        return this;
    }

    private Reference[] getReferences(IMObject ... objects) {
        Reference[] result = new Reference[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = objects[i].getObjectReference();
        }
        return result;
    }

    private IMObjectCopierBuilder add(Set<String> set, String ... archetypes) {
        for (String archetype : archetypes) {
            this.checkWildcard(archetype, "archetype");
            set.add(archetype);
        }
        return this;
    }

    private void checkWildcard(String archetype, String name) {
        if (archetype != null && archetype.contains("*")) {
            throw new IllegalArgumentException("Argument '" + name + "' cannot contain wildcards");
        }
    }

    private static enum Treatment {
        REFERENCE,
        COPY,
        EXCLUDE;

    }

    private static class State {
        private final Set<Reference> objectsToExclude = new HashSet<Reference>();
        private final Set<Reference> objectsToReference = new HashSet<Reference>();
        private final Set<Reference> objectsToCopy = new HashSet<Reference>();
        private final Set<String> archetypesToExclude = new HashSet<String>();
        private final Set<String> archetypesToReference = new HashSet<String>();
        private final Set<String> archetypesToCopy = new HashSet<String>();
        private final Types typesToExclude = new Types();
        private final Types typesToReference = new Types();
        private final Types typesToCopy = new Types();
        private final List<Pair<String, String>> map = new ArrayList<Pair<String, String>>();
        private Treatment defaultTreatment = Treatment.EXCLUDE;

        private State() {
        }

        private static class Types {
            private final Set<Class<?>> types = new HashSet();

            private Types() {
            }

            public void add(Class<?> ... types) {
                this.types.addAll(Arrays.asList(types));
            }

            public boolean matches(IMObject object) {
                for (Class<?> type : this.types) {
                    if (!type.isAssignableFrom(object.getClass())) continue;
                    return true;
                }
                return false;
            }
        }
    }

    private static class Handler
    extends AbstractIMObjectCopyHandler {
        private final State state;
        private static final String MAP_TO_NULL = "__MAP_TO_NULL";

        protected Handler(State state) {
            this.state = state;
        }

        @Override
        public IMObject getObject(IMObject object, ArchetypeService service) {
            IMObject result;
            if (this.state.objectsToExclude.contains(object.getObjectReference())) {
                result = null;
            } else {
                String from = object.getArchetype();
                String to = this.mapTo(from);
                if (MAP_TO_NULL.equals(to)) {
                    result = null;
                } else if (to != null) {
                    result = service.create(to, IMObject.class);
                } else {
                    switch (this.getTreatment(object)) {
                        case REFERENCE: {
                            result = object;
                            break;
                        }
                        case COPY: {
                            result = service.create(object.getArchetype(), IMObject.class);
                            break;
                        }
                        default: {
                            result = null;
                        }
                    }
                }
            }
            return result;
        }

        protected String mapTo(String archetype) {
            String result = null;
            for (Pair pair : this.state.map) {
                if (!archetype.equals(pair.getLeft())) continue;
                String to = (String)pair.getRight();
                result = to == null ? MAP_TO_NULL : to;
                break;
            }
            return result;
        }

        private Treatment getTreatment(IMObject object) {
            Reference reference = object.getObjectReference();
            Treatment result = this.state.objectsToExclude.contains(reference) ? Treatment.EXCLUDE : (this.state.objectsToReference.contains(reference) ? Treatment.REFERENCE : (this.state.objectsToCopy.contains(reference) ? Treatment.COPY : (this.state.archetypesToExclude.contains(reference.getArchetype()) ? Treatment.EXCLUDE : (this.state.archetypesToReference.contains(reference.getArchetype()) ? Treatment.REFERENCE : (this.state.archetypesToCopy.contains(reference.getArchetype()) ? Treatment.COPY : (this.state.typesToExclude.matches(object) ? Treatment.EXCLUDE : (this.state.typesToReference.matches(object) ? Treatment.REFERENCE : (this.state.typesToCopy.matches(object) ? Treatment.COPY : this.state.defaultTreatment))))))));
            return result;
        }
    }
}

