/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.functor.IsA;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.lookup.LookupService;

public class ActBean
extends IMObjectBean {
    public ActBean(Act act) {
        this(act, (IArchetypeService)null);
    }

    public ActBean(Act act, IArchetypeService service) {
        super(act, service);
    }

    public ActBean(Act act, IArchetypeService service, LookupService lookups) {
        super(act, service, lookups);
    }

    public Act getAct() {
        return (Act)this.getObject();
    }

    public void setStatus(String status) {
        this.getAct().setStatus(status);
    }

    public String getStatus() {
        return this.getAct().getStatus();
    }

    public ActRelationship addRelationship(String shortName, Act target) {
        Act act = this.getAct();
        ActRelationship r = (ActRelationship)this.getArchetypeService().create(shortName, ActRelationship.class);
        r.setSource(act.getObjectReference());
        r.setTarget(target.getObjectReference());
        act.addActRelationship(r);
        target.addActRelationship(r);
        return r;
    }

    public ActRelationship getRelationship(Act target) {
        Act act = this.getAct();
        IMObjectReference ref = target.getObjectReference();
        for (org.openvpms.component.model.act.ActRelationship r : act.getSourceActRelationships()) {
            if (!ref.equals(r.getTarget())) continue;
            return (ActRelationship)r;
        }
        return null;
    }

    public boolean hasRelationship(String shortName, Act target) {
        return this.hasRelationship(shortName, target.getObjectReference());
    }

    public boolean hasRelationship(String shortName, Reference target) {
        for (ActRelationship relationship : this.getRelationships(shortName)) {
            if (!relationship.getTarget().equals(target)) continue;
            return true;
        }
        return false;
    }

    public void removeRelationship(ActRelationship relationship) {
        Act act = this.getAct();
        act.removeActRelationship(relationship);
    }

    public ActRelationship getRelationship(String shortName) {
        return (ActRelationship)this.selectFirst(this.getAct().getActRelationships(), new IsA(shortName));
    }

    public boolean hasRelationship(String shortName) {
        return this.getRelationship(shortName) != null;
    }

    public List<ActRelationship> getRelationships(String shortName) {
        Set<org.openvpms.component.model.act.ActRelationship> set = this.getAct().getActRelationships();
        return this.select(set, Predicates.isA((String[])new String[]{shortName}));
    }

    public ActRelationship addNodeRelationship(String name, Act target) {
        String shortName = this.getRelationshipTargetArchetype(name, target);
        return this.addRelationship(shortName, target);
    }

    public void removeNodeRelationships(String name, Act target) {
        List<ActRelationship> relationships = this.getValues(name, ActRelationship.class, Predicates.targetEquals((IMObject)target));
        for (ActRelationship relationship : relationships) {
            this.removeRelationship(relationship);
            target.removeTargetActRelationship(relationship);
        }
    }

    public List<Act> getActs() {
        ArrayList<Act> result = new ArrayList<Act>();
        Act act = this.getAct();
        for (Relationship relationship : act.getSourceActRelationships()) {
            Act child = (Act)this.resolve(relationship.getTarget(), Policy.State.ANY);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public List<Act> getActs(String shortName) {
        ArrayList<Act> result = new ArrayList<Act>();
        Act act = this.getAct();
        for (Relationship relationship : act.getSourceActRelationships()) {
            Act child;
            Reference target = relationship.getTarget();
            if (!target.isA(shortName) || (child = (Act)this.resolve(target, Policy.State.ANY)) == null) continue;
            result.add(child);
        }
        return result;
    }

    public List<Act> getNodeActs(String name) {
        return this.getNodeActs(name, Act.class);
    }

    public <T extends Act> List<T> getNodeActs(String name, Class<T> type) {
        return this.getRelated(name, type, Policies.any());
    }

    public Act getSourceAct(String shortName) {
        return this.getSourceAct(new String[]{shortName});
    }

    public Act getSourceAct(String[] shortNames) {
        return (Act)this.getSourceObject(this.getAct().getTargetActRelationships(), shortNames);
    }

    public List<Act> getSourceActs(String shortName) {
        return this.getSourceActs(new String[]{shortName});
    }

    public List<Act> getSourceActs(String[] shortNames) {
        return this.getSourceObjects(this.getAct().getTargetActRelationships(), shortNames, Act.class);
    }

    public Act getTargetAct(String shortName) {
        return this.getTargetAct(new String[]{shortName});
    }

    public Act getTargetAct(String[] shortNames) {
        return (Act)this.getTargetObject(this.getAct().getSourceActRelationships(), shortNames);
    }

    public List<Act> getTargetActs(String shortName) {
        return this.getTargetActs(new String[]{shortName});
    }

    public List<Act> getTargetActs(String[] shortNames) {
        return this.getTargetObjects(this.getAct().getSourceActRelationships(), shortNames, Act.class);
    }

    public Participation addParticipation(String shortName, Entity entity) {
        return this.addParticipation(shortName, entity.getObjectReference());
    }

    public Participation addParticipation(String shortName, Reference entity) {
        Act act = this.getAct();
        Participation p = (Participation)this.getArchetypeService().create(shortName, Participation.class);
        p.setAct(act.getObjectReference());
        p.setEntity(entity);
        act.addParticipation(p);
        return p;
    }

    public Participation getParticipation(String shortName) {
        return (Participation)this.selectFirst(this.getAct().getParticipations(), new IsA(shortName));
    }

    public Participation removeParticipation(String shortName) {
        Participation p = this.getParticipation(shortName);
        if (p != null) {
            this.getAct().removeParticipation(p);
        }
        return p;
    }

    public IMObjectReference getParticipantRef(String shortName) {
        Participation p = this.getParticipation(shortName);
        return p != null ? p.getEntity() : null;
    }

    public Entity getParticipant(String shortName) {
        IMObjectReference ref = this.getParticipantRef(shortName);
        return (Entity)this.resolve(ref, Policy.State.ANY);
    }

    public Participation setParticipant(String shortName, Entity entity) {
        return this.setParticipant(shortName, entity.getObjectReference());
    }

    public Participation setParticipant(String shortName, Reference entity) {
        Participation p = this.getParticipation(shortName);
        if (p == null) {
            p = this.addParticipation(shortName, entity);
        } else {
            p.setEntity(entity);
        }
        return p;
    }

    public IMObjectReference getNodeParticipantRef(String name) {
        return (IMObjectReference)this.getTargetRef(name);
    }

    public Entity getNodeParticipant(String name) {
        return this.getTarget(name, Entity.class);
    }

    public Participation setNodeParticipant(String name, Entity entity) {
        return (Participation)this.setTarget(name, entity);
    }

    public Participation setNodeParticipant(String name, Reference entity) {
        return (Participation)this.setTarget(name, entity);
    }

    public Participation addNodeParticipation(String name, Entity target) {
        return (Participation)this.addTarget(name, target);
    }

    public Participation addNodeParticipation(String name, Reference target) {
        return (Participation)this.addTarget(name, target);
    }
}

