/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractMonitoringIMObjectCache<T extends IMObject>
implements DisposableBean {
    private final IArchetypeService service;
    private final IArchetypeServiceListener listener;
    private final String[] archetypes;
    private final Class<T> type;
    private final AtomicBoolean monitoring = new AtomicBoolean();

    protected AbstractMonitoringIMObjectCache(IArchetypeService service, String shortName, Class<T> type) {
        this(service, shortName, type, true);
    }

    protected AbstractMonitoringIMObjectCache(IArchetypeService service, String shortName, Class<T> type, boolean monitor) {
        this(service, new String[]{shortName}, type, monitor);
    }

    protected AbstractMonitoringIMObjectCache(IArchetypeService service, String[] archetypes, Class<T> type) {
        this(service, archetypes, type, true);
    }

    protected AbstractMonitoringIMObjectCache(IArchetypeService service, String[] archetypes, final Class<T> type, boolean monitor) {
        this.service = service;
        this.archetypes = archetypes;
        this.type = type;
        this.listener = new AbstractArchetypeServiceListener(){

            @Override
            public void saved(IMObject object) {
                AbstractMonitoringIMObjectCache.this.addObject((IMObject)type.cast(object));
            }

            @Override
            public void removed(IMObject object) {
                AbstractMonitoringIMObjectCache.this.removeObject((IMObject)type.cast(object));
            }
        };
        if (monitor) {
            this.monitor();
        }
    }

    public void monitor() {
        if (!this.monitoring.getAndSet(true)) {
            for (String shortName : this.archetypes) {
                this.service.addListener(shortName, this.listener);
            }
        }
    }

    public void destroy() {
        if (this.monitoring.getAndSet(false)) {
            for (String shortName : this.archetypes) {
                this.service.removeListener(shortName, this.listener);
            }
        }
    }

    protected String[] getArchetypes() {
        return this.archetypes;
    }

    protected void load() {
        String[] matches = DescriptorHelper.getShortNames(this.archetypes, true, (ArchetypeService)this.service);
        if (matches.length > 0) {
            ArchetypeQuery query = new ArchetypeQuery(this.archetypes, true, true);
            IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, query);
            while (iter.hasNext()) {
                this.addObject((IMObject)iter.next());
            }
        }
    }

    protected abstract T addObject(T var1);

    protected abstract void removeObject(T var1);

    protected IArchetypeService getService() {
        return this.service;
    }

    protected T get(Reference reference) {
        return (T)((IMObject)this.type.cast(this.service.get(reference)));
    }
}

