/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractIMObjectCopyHandler
implements IMObjectCopyHandler {
    @Override
    public IMObject getObject(IMObject object, ArchetypeService service) {
        return service.create(object.getArchetype(), IMObject.class);
    }

    @Override
    public NodeDescriptor getNode(ArchetypeDescriptor source, NodeDescriptor sourceNode, ArchetypeDescriptor target) {
        NodeDescriptor result = null;
        if (this.isCopyable(source, sourceNode, true)) {
            result = this.getTargetNode(source, sourceNode, target);
        }
        return result;
    }

    protected NodeDescriptor getTargetNode(ArchetypeDescriptor source, NodeDescriptor sourceNode, ArchetypeDescriptor target) {
        NodeDescriptor result = null;
        NodeDescriptor desc = target.getNodeDescriptor(sourceNode.getName());
        if (desc != null && this.isCopyable(target, desc, false)) {
            result = desc;
        }
        return result;
    }

    protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
        String name = node.getName();
        return !"id".equals(name) && !"created".equals(name) && !"updated".equals(name) && !"createdBy".equals(name) && !"updatedBy".equals(name) && !node.isDerived();
    }
}

