/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.openvpms.component.business.service.archetype.handler.ConfigReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesReader
extends ConfigReader {
    private static final Logger log = LoggerFactory.getLogger(PropertiesReader.class);

    protected abstract void parse(String var1, String var2, String var3);

    @Override
    protected void read(URL url) {
        try {
            Properties properties = new Properties();
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            Enumeration<?> keys = properties.propertyNames();
            String path = url.toString();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key).trim();
                this.parse(key, value, path);
            }
        }
        catch (IOException exception) {
            log.error("Failed to read properties: " + url, (Throwable)exception);
        }
    }
}

