/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.handler;

import com.thoughtworks.xstream.XStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.handler.AbstractArchetypeHandlers;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ConfigReader;
import org.openvpms.component.business.service.archetype.handler.PropertiesReader;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.xstream.XStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchetypeHandlers<T>
extends AbstractArchetypeHandlers<T> {
    private final Class<T> type;
    private final Map<String, ArchetypeHandler<T>> handlers = new HashMap<String, ArchetypeHandler<T>>();
    private final Map<String, ArchetypeHandler<T>> anonymousHandlers = new HashMap<String, ArchetypeHandler<T>>();
    private static final XStream stream = XStreamFactory.create(Handlers.class, Handler.class);
    private static final Logger log = LoggerFactory.getLogger(ArchetypeHandlers.class);

    public ArchetypeHandlers(String name, Class<T> type, ArchetypeService service) {
        this(name, null, type, service);
    }

    public ArchetypeHandlers(String name, String fallbackName, Class<T> type, ArchetypeService service) {
        this(name, fallbackName, type, null, service);
    }

    public ArchetypeHandlers(String name, String fallbackName, Class<T> type, String anonymousPrefix, ArchetypeService service) {
        super(service);
        this.type = type;
        if (fallbackName != null) {
            this.read(fallbackName, false, anonymousPrefix);
        }
        this.read(name, true, anonymousPrefix);
    }

    @Override
    public ArchetypeHandler<T> getHandler(String shortName) {
        return this.getHandler(new String[]{shortName});
    }

    public ArchetypeHandler<T> getHandler(String[] shortNames) {
        return this.getHandler(shortNames, true);
    }

    public ArchetypeHandler<T> getHandler(String[] shortNames, boolean exact) {
        ArchetypeHandler<T> result;
        block7: {
            result = null;
            Set<String> wildcards = this.handlers.keySet();
            HashMap<String, String> matches = new HashMap<String, String>();
            for (String wildcard : wildcards) {
                for (String shortName : shortNames) {
                    String match;
                    if (!TypeHelper.matches(shortName, wildcard) || (match = (String)matches.get(shortName)) != null && !this.moreSpecific(wildcard, match)) continue;
                    matches.put(shortName, wildcard);
                }
            }
            if (matches.size() != shortNames.length) break block7;
            if (exact) {
                for (String match : matches.values()) {
                    ArchetypeHandler<T> handler = this.handlers.get(match);
                    if (result == null) {
                        result = handler;
                        continue;
                    }
                    if (result.getType().equals(handler.getType()) && Objects.equals(result.getProperties(), handler.getProperties())) continue;
                    result = null;
                    break;
                }
            } else {
                for (String match : matches.values()) {
                    if (!TypeHelper.matches(shortNames, match)) continue;
                    result = this.handlers.get(match);
                }
            }
        }
        return result;
    }

    public ArchetypeHandler<T> getHandler(Class<?> type) {
        return this.anonymousHandlers.get(type.getName());
    }

    private void read(String name, boolean replace, String anonymousPrefix) {
        if (name.endsWith(".properties")) {
            this.readProperties(name, replace, anonymousPrefix);
        } else if (name.endsWith(".xml")) {
            this.readXML(name, replace);
        } else {
            this.readProperties(name + ".properties", replace, anonymousPrefix);
            this.readXML(name + ".xml", replace);
        }
    }

    private boolean moreSpecific(String shortName1, String shortName2) {
        boolean hasWildcard1 = shortName1.contains("*");
        boolean hasWildcard2 = shortName2.contains("*");
        if (hasWildcard1 && hasWildcard2) {
            String[] matches2;
            String[] matches1 = this.getShortNames(shortName1);
            return matches1.length < (matches2 = this.getShortNames(shortName2)).length;
        }
        boolean result = !hasWildcard1;
        return result;
    }

    private void addHandler(String shortName, Class<T> type, Map<String, Object> properties, String path, boolean replace) {
        if (!StringUtils.isEmpty((CharSequence)shortName)) {
            this.addHandlerForArchetype(shortName, type, properties, path, replace);
        } else {
            this.addAnonymousHandler(type, properties, path, replace);
        }
    }

    private void addHandlerForArchetype(String shortName, Class<T> type, Map<String, Object> properties, String path, boolean replace) {
        if (!replace && this.handlers.get(shortName) != null) {
            log.warn("Duplicate short name={} from path={}: ignoring", (Object)shortName, (Object)path);
        } else {
            log.debug("Replacing handler for short name={} with handler from path={}", (Object)shortName, (Object)path);
            ArchetypeHandler<T> handler = new ArchetypeHandler<T>(shortName, type, properties);
            this.handlers.put(shortName, handler);
        }
        String[] matches = this.getShortNames(shortName, false);
        if (matches.length == 0 && !shortName.contains("*")) {
            log.warn("No archetypes found matching short name={}, loaded from path={}", (Object)shortName, (Object)path);
        }
    }

    private void addAnonymousHandler(Class<T> type, Map<String, Object> properties, String path, boolean replace) {
        String name = type.getName();
        if (!replace && this.anonymousHandlers.get(name) != null) {
            log.warn("Duplicate anonymous handler={} from path={}: ignoring", (Object)name, (Object)path);
        } else {
            ArchetypeHandler<T> handler = new ArchetypeHandler<T>(null, type, properties);
            this.anonymousHandlers.put(name, handler);
        }
    }

    private void readXML(String name, boolean replace) {
        XMLConfigReader reader = new XMLConfigReader(replace);
        reader.read(name);
    }

    private void readProperties(String name, boolean replace, String anonymousPrefix) {
        Reader parser = new Reader(replace, anonymousPrefix);
        parser.read(name);
    }

    private class XMLConfigReader
    extends ConfigReader {
        private final boolean replace;

        XMLConfigReader(boolean replace) {
            this.replace = replace;
            stream.alias("handler", Handler.class);
            stream.alias("handlers", Handlers.class);
            stream.addImplicitCollection(Handlers.class, "handlers");
        }

        @Override
        protected void read(URL path) {
            try {
                Handlers handlers = (Handlers)stream.fromXML(path.openStream());
                for (Handler handler : handlers) {
                    Class<?> clazz = this.getClass(handler.getType(), ArchetypeHandlers.this.type, path.toString());
                    if (clazz == null) continue;
                    ArchetypeHandlers.this.addHandler(handler.getShortName(), clazz, handler.getProperties(), path.toString(), this.replace);
                }
            }
            catch (Exception exception) {
                log.error("Failed to read {}", (Object)path, (Object)exception);
            }
        }
    }

    private class Reader
    extends PropertiesReader {
        private final boolean replace;
        private final String anonymousPrefix;

        Reader(boolean replace, String anonymousPrefix) {
            this.replace = replace;
            this.anonymousPrefix = anonymousPrefix;
        }

        @Override
        protected void parse(String key, String value, String path) {
            String[] properties = value.split(",");
            if (properties.length == 0) {
                log.warn("Invalid properties for short name={}, loaded from path={}", (Object)key, (Object)path);
            } else {
                Class<?> clazz = this.getClass(properties[0], ArchetypeHandlers.this.type, path);
                if (clazz != null) {
                    HashMap<String, String> config = new HashMap<String, String>();
                    for (int i = 1; i < properties.length; ++i) {
                        String[] pair = properties[i].split("=");
                        config.put(pair[0], pair[1]);
                    }
                    if (key != null && this.anonymousPrefix != null && key.startsWith(this.anonymousPrefix)) {
                        key = null;
                    }
                    ArchetypeHandlers.this.addHandler(key, clazz, config, path, this.replace);
                }
            }
        }
    }

    public static class Handler {
        private String shortName;
        private String type;
        private Map<String, Object> properties;

        public String getShortName() {
            return this.shortName;
        }

        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }

    public static class Handlers
    implements Iterable<Handler> {
        private final List<Handler> handlers = new ArrayList<Handler>();

        public void add(Handler handler) {
            this.handlers.add(handler);
        }

        @Override
        public Iterator<Handler> iterator() {
            return this.handlers.iterator();
        }
    }
}

