/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.functor;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.Predicate;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;

public class NodeEquals
implements Predicate {
    private final IArchetypeService service;
    private final String node;
    private final Object value;
    private final Map<String, NodeDescriptor> nodes = new HashMap<String, NodeDescriptor>();

    public NodeEquals(String node, Object value, IArchetypeService service) {
        this.node = node;
        this.value = value;
        this.service = service;
    }

    public boolean evaluate(Object object) {
        boolean result = false;
        IMObject obj = (IMObject)object;
        NodeDescriptor descriptor = this.getDescriptor(obj);
        if (descriptor != null) {
            Object other = descriptor.getValue(obj);
            result = this.value instanceof BigDecimal && other instanceof BigDecimal ? ((BigDecimal)this.value).compareTo((BigDecimal)other) == 0 : Objects.equals(this.value, other);
        }
        return result;
    }

    private NodeDescriptor getDescriptor(IMObject object) {
        ArchetypeDescriptor archetype;
        String shortName = object.getArchetype();
        NodeDescriptor desc = this.nodes.get(shortName);
        if (desc == null && (archetype = this.service.getArchetypeDescriptor(shortName)) != null && (desc = archetype.getNodeDescriptor(this.node)) != null) {
            this.nodes.put(this.node, desc);
        }
        return desc;
    }
}

