/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.descriptor.cache;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptors;
import org.openvpms.component.business.service.archetype.descriptor.cache.ArchetypeDescriptorCacheException;
import org.openvpms.component.business.service.archetype.descriptor.cache.BaseArchetypeDescriptorCache;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.xml.sax.InputSource;

public class ArchetypeDescriptorCacheFS
extends BaseArchetypeDescriptorCache
implements IArchetypeDescriptorCache {
    private final BeanFactory beans;
    private static final Logger logger = LoggerFactory.getLogger(ArchetypeDescriptorCacheFS.class);
    private static final String ARCHETYPE_MAPPING_PATH = "org/openvpms/component/business/domain/im/archetype/descriptor/archetype-mapping-file.xml";
    private static final String ASSERTION_MAPPING_PATH = "org/openvpms/component/business/domain/im/archetype/descriptor/assertion-type-mapping-file.xml";

    public ArchetypeDescriptorCacheFS(String archeFile, String assertFile) {
        this(archeFile, assertFile, null);
    }

    public ArchetypeDescriptorCacheFS(String archeFile, String assertFile, BeanFactory beans) {
        this.beans = beans;
        this.loadAssertionTypeDescriptorsFromFile(assertFile);
        this.loadArchetypeDescriptorsInFile(archeFile);
    }

    public ArchetypeDescriptorCacheFS(String archDir, String[] extensions, String assertFile) {
        this(archDir, extensions, assertFile, null);
    }

    public ArchetypeDescriptorCacheFS(String archDir, String[] extensions, String assertFile, BeanFactory beans) {
        this.beans = beans;
        this.loadAssertionTypeDescriptorsFromFile(assertFile);
        this.loadArchetypeDescriptorsInDir(archDir, extensions);
    }

    @Override
    protected void processAssertion(AssertionDescriptor assertion) {
        super.processAssertion(assertion);
        assertion.setBeans(this.beans);
    }

    private void loadArchetypeDescriptorsInFile(String afile) {
        if (StringUtils.isEmpty((CharSequence)afile)) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.NoFileSpecified);
        }
        try {
            logger.debug("Attempting to process records in {}", (Object)afile);
            this.processArchetypeDescriptors(this.loadArchetypeDescriptors(afile));
        }
        catch (Exception exception) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidFile, new Object[]{afile}, exception);
        }
    }

    private void loadArchetypeDescriptorsInDir(String adir, String[] extensions) {
        if (StringUtils.isEmpty((CharSequence)adir)) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.NoDirSpecified);
        }
        File dir = FileUtils.toFile((URL)Thread.currentThread().getContextClassLoader().getResource(adir));
        if (dir == null) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidDir, new Object[]{adir});
        }
        if (!dir.isDirectory()) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidDir, new Object[]{adir});
        }
        for (File file : FileUtils.listFiles((File)dir, (String[])extensions, (boolean)true)) {
            try {
                logger.debug("Attempting to process records in {}", (Object)file.getName());
                this.processArchetypeDescriptors(this.loadArchetypeDescriptors(new FileReader(file)));
            }
            catch (Exception exception) {
                logger.warn("Failed to load archetype", (Throwable)((Object)new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidFile, new Object[]{file.getName()}, exception)));
            }
        }
    }

    private void processArchetypeDescriptors(ArchetypeDescriptors descriptors) {
        for (ArchetypeDescriptor descriptor : descriptors.getArchetypeDescriptorsAsArray()) {
            ArchetypeId archId = descriptor.getType();
            logger.debug("Processing archetype record {}", (Object)archId.getShortName());
            try {
                Thread.currentThread().getContextClassLoader().loadClass(descriptor.getClassName());
                this.addArchetypeDescriptor(descriptor);
            }
            catch (ClassNotFoundException excpetion) {
                throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.FailedToLoadClass, new Object[]{descriptor.getClassName()}, excpetion);
            }
            Map<String, NodeDescriptor> nodeDescriptors = descriptor.getNodeDescriptorMap();
            if (nodeDescriptors.size() <= 0) continue;
            this.checkAssertionsInNode(nodeDescriptors);
        }
    }

    private void loadAssertionTypeDescriptorsFromFile(String assertFile) {
        if (StringUtils.isEmpty((CharSequence)assertFile)) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.NoAssertionTypeFileSpecified);
        }
        try {
            logger.debug("Attempting to process file {}", (Object)assertFile);
            AssertionTypeDescriptors types = this.loadAssertionTypeDescriptors(assertFile);
            for (AssertionTypeDescriptor descriptor : types.getAssertionTypeDescriptors().values()) {
                this.addAssertionTypeDescriptor(descriptor);
                logger.debug("Loaded assertion type {}", (Object)descriptor.getName());
            }
        }
        catch (Exception exception) {
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidAssertionFile, new Object[]{assertFile}, exception);
        }
    }

    private ArchetypeDescriptors loadArchetypeDescriptors(String resourceName) throws MappingException, MarshalException, ValidationException {
        Mapping mapping = new Mapping();
        mapping.loadMapping(this.getResource(ARCHETYPE_MAPPING_PATH));
        Unmarshaller unmarshaller = new Unmarshaller(mapping);
        InputSource descriptors = this.getResource(resourceName);
        return (ArchetypeDescriptors)unmarshaller.unmarshal(descriptors);
    }

    private ArchetypeDescriptors loadArchetypeDescriptors(Reader reader) throws Exception {
        Mapping mapping = new Mapping();
        mapping.loadMapping(this.getResource(ARCHETYPE_MAPPING_PATH));
        return (ArchetypeDescriptors)new Unmarshaller(mapping).unmarshal(reader);
    }

    private AssertionTypeDescriptors loadAssertionTypeDescriptors(String assertFile) throws MappingException, MarshalException, ValidationException {
        Mapping mapping = new Mapping();
        mapping.loadMapping(this.getResource(ASSERTION_MAPPING_PATH));
        return (AssertionTypeDescriptors)new Unmarshaller(mapping).unmarshal(this.getResource(assertFile));
    }

    private InputSource getResource(String resourceName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(resourceName);
        if (stream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourceName);
        }
        return new InputSource(new InputStreamReader(stream));
    }
}

