/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.descriptor.cache;

import java.util.List;
import java.util.Map;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.BaseArchetypeDescriptorCache;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.util.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ArchetypeDescriptorCacheDB
implements IArchetypeDescriptorCache,
InitializingBean {
    private IMObjectDAO dao;
    private Cache cache = new Cache(false);
    private static final Logger log = LoggerFactory.getLogger(ArchetypeDescriptorCacheDB.class);

    public void setDao(IMObjectDAO dao) {
        this.dao = dao;
    }

    public void afterPropertiesSet() {
        this.cache.load();
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(String name) {
        return this.cache.getArchetypeDescriptor(name);
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(ArchetypeId id) {
        return this.cache.getArchetypeDescriptor(id);
    }

    @Override
    public List<ArchetypeDescriptor> getArchetypeDescriptors() {
        return this.cache.getArchetypeDescriptors();
    }

    @Override
    public List<ArchetypeDescriptor> getArchetypeDescriptors(String shortName) {
        return this.cache.getArchetypeDescriptors(shortName);
    }

    @Override
    public AssertionTypeDescriptor getAssertionTypeDescriptor(String name) {
        return this.cache.getAssertionTypeDescriptor(name);
    }

    @Override
    public List<AssertionTypeDescriptor> getAssertionTypeDescriptors() {
        return this.cache.getAssertionTypeDescriptors();
    }

    @Override
    public List<String> getArchetypeShortNames(String entityName, String conceptName, boolean primaryOnly) {
        return this.cache.getArchetypeShortNames(entityName, conceptName, primaryOnly);
    }

    @Override
    public List<String> getArchetypeShortNames(String shortName, boolean primaryOnly) {
        return this.cache.getArchetypeShortNames(shortName, primaryOnly);
    }

    @Override
    public void addArchetypeDescriptor(ArchetypeDescriptor descriptor) {
        this.cache.addArchetypeDescriptor(descriptor);
    }

    @Override
    public void addAssertionTypeDescriptor(AssertionTypeDescriptor descriptor) {
        this.cache.addAssertionTypeDescriptor(descriptor);
    }

    @Override
    public List<String> getArchetypeShortNames() {
        return this.cache.getArchetypeShortNames();
    }

    public void refresh() {
        this.cache = new Cache();
    }

    private class Cache
    extends BaseArchetypeDescriptorCache {
        public Cache() {
            this(true);
        }

        public Cache(boolean load) {
            if (load) {
                this.load();
            }
        }

        public void load() {
            this.loadAssertionTypeDescriptors();
            this.loadArchetypeDescriptors();
        }

        private void loadAssertionTypeDescriptors() {
            List<IMObject> types = ArchetypeDescriptorCacheDB.this.dao.get("descriptor.assertionType", null, AssertionTypeDescriptor.class.getName(), true, 0, -1).getResults();
            for (IMObject type : types) {
                if (type instanceof AssertionTypeDescriptor) {
                    AssertionTypeDescriptor descriptor = (AssertionTypeDescriptor)type;
                    this.addAssertionTypeDescriptor(descriptor);
                    log.debug("Loaded assertion type {}", (Object)descriptor.getName());
                    continue;
                }
                log.warn("Invalid assertion type object. Found object of type {}", (Object)type.getClass().getName());
            }
        }

        private void loadArchetypeDescriptors() {
            IPage<IMObject> page = ArchetypeDescriptorCacheDB.this.dao.get("descriptor.*", null, ArchetypeDescriptor.class.getName(), true, 0, -1);
            for (IMObject object : page.getResults()) {
                if (object instanceof ArchetypeDescriptor) {
                    this.loadArchetypeDescriptor((ArchetypeDescriptor)object);
                    continue;
                }
                log.warn("loadArchetypeDescriptors found object of type {}", (Object)object.getClass().getName());
            }
        }

        private void loadArchetypeDescriptor(ArchetypeDescriptor descriptor) {
            ArchetypeId archId = descriptor.getType();
            log.debug("Processing archetype {}", (Object)archId.getShortName());
            try {
                ClassHelper.getClass(descriptor.getClassName());
                Map<String, NodeDescriptor> nodeDescriptors = descriptor.getNodeDescriptorMap();
                if (!nodeDescriptors.isEmpty()) {
                    this.checkAssertionsInNode(nodeDescriptors);
                }
                log.debug("Loading  archetype {}", (Object)archId.getShortName());
                this.addArchetypeDescriptor(descriptor);
            }
            catch (Exception exception) {
                log.warn("Failed to load descriptor {}", (Object)descriptor.getName(), (Object)exception);
            }
        }
    }
}

