/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ActionContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.lookup.LookupService;

public class LookupAssertions {
    private LookupAssertions() {
    }

    public static boolean isStringValueInList(Object target, NodeDescriptor node, AssertionDescriptor assertion) {
        PropertyList entries = (PropertyList)assertion.getPropertyMap().getProperties().get("entries");
        if (entries == null) {
            return false;
        }
        if (target != null && !(target instanceof String)) {
            target = target.toString();
        }
        for (NamedProperty property : entries.getProperties()) {
            AssertionProperty prop = (AssertionProperty)property;
            if (!prop.getName().equals(target)) continue;
            return true;
        }
        return false;
    }

    public static void setDefaultValue(ActionContext context) {
        LookupService lookups;
        Lookup lookup;
        String source;
        String type;
        AssertionDescriptor assertion = context.getAssertion();
        NodeDescriptor node = context.getNode();
        if (assertion.getName().equals("lookup") && StringUtils.isEmpty((CharSequence)node.getDefaultValue()) && !StringUtils.isEmpty((CharSequence)(type = (String)assertion.getProperty("type").getValue())) && type.equals("lookup") && assertion.getProperty("source") != null && !StringUtils.isEmpty((CharSequence)(source = (String)assertion.getProperty("source").getValue())) && (lookup = (lookups = context.getBean(LookupService.class)).getDefaultLookup(source)) != null) {
            IMObject target = (IMObject)context.getValue();
            node.setValue(target, lookup.getCode());
        }
    }

    public static boolean alwaysTrue(Object target, NodeDescriptor node, AssertionDescriptor assertion) {
        return true;
    }
}

