/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;

public class AssertionBeanFactory
implements BeanFactory,
ApplicationContextAware {
    private final StaticListableBeanFactory beans = new StaticListableBeanFactory();
    private final List<String> names;
    private ApplicationContext context;
    private boolean initialised;

    public AssertionBeanFactory(List<String> names) {
        this.names = names;
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeans().getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.getBeans().getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.getBeans().getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.getBeans().getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)this.getBeans().getBean(requiredType, args);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return this.getBeans().getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.getBeans().getBeanProvider(requiredType);
    }

    public boolean containsBean(String name) {
        return this.getBeans().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeans().isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.getBeans().isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.getBeans().isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.getBeans().getType(name);
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.getBeans().getType(name, allowFactoryBeanInit);
    }

    public String[] getAliases(String name) {
        return this.getBeans().getAliases(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    private synchronized BeanFactory getBeans() {
        if (!this.initialised) {
            for (String name : this.names) {
                if (!this.context.containsBean(name)) continue;
                this.beans.addBean(name, this.context.getBean(name));
            }
            this.initialised = true;
        }
        return this.beans;
    }
}

