/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyCollection;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyMap;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.assertion.AssertionRuntimeException;
import org.openvpms.component.business.service.archetype.helper.ArchetypeQueryHelper;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.system.common.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchetypeRangeAssertion {
    private static final Logger logger = LoggerFactory.getLogger(ArchetypeRangeAssertion.class);

    private ArchetypeRangeAssertion() {
    }

    public static void create(Object target, NodeDescriptor node, AssertionDescriptor assertion) {
        if (node.isCollection() && !node.isParentChild()) {
            List<ArchetypeRangeInfo> atypes = ArchetypeRangeAssertion.getArchetypeRangeInfo(assertion);
            if (atypes.isEmpty()) {
                return;
            }
            for (ArchetypeRangeInfo type : atypes) {
                if (StringUtils.isEmpty((CharSequence)type.defaultValue)) continue;
                ArchetypeDescriptor adesc = ArchetypeServiceHelper.getArchetypeService().getArchetypeDescriptor(type.shortName);
                if (adesc == null) {
                    throw new AssertionRuntimeException(AssertionRuntimeException.ErrorCode.ArchetypeDoesNotExist, new Object[]{"archetypeRangeAssertion", "create", type.shortName});
                }
                try {
                    ArchetypeId aid = adesc.getType();
                    List<IMObject> objects = ArchetypeQueryHelper.get(ArchetypeServiceHelper.getArchetypeService(), aid.getEntityName(), aid.getConcept(), type.defaultValue, true, 0, -1).getResults();
                    if (objects.isEmpty()) {
                        throw new AssertionRuntimeException(AssertionRuntimeException.ErrorCode.FailedToFindArchetype, new Object[]{"archetypeRangeAssertion", "create", type.shortName, type.defaultValue});
                    }
                    if (objects.size() > 1) {
                        throw new AssertionRuntimeException(AssertionRuntimeException.ErrorCode.TooManyObjectOnCreate, new Object[]{"archetypeRangeAssertion", "create", type.shortName, type.defaultValue});
                    }
                    node.addChildToCollection((IMObject)target, objects.get(0));
                }
                catch (Exception exception) {
                    throw new AssertionRuntimeException(AssertionRuntimeException.ErrorCode.FailedInCreate, new Object[]{"archetypeRangeAssertion", "create", type.shortName}, exception);
                }
            }
        }
    }

    public static boolean validate(Object target, NodeDescriptor node, AssertionDescriptor assertion) {
        List<ArchetypeRangeInfo> atypes = ArchetypeRangeAssertion.getArchetypeRangeInfo(assertion);
        if (target == null) {
            return true;
        }
        if (atypes.isEmpty()) {
            return true;
        }
        Collection<Object> entries = null;
        if (target instanceof Collection) {
            entries = (Collection)target;
        } else if (target instanceof Map) {
            entries = ((Map)target).values();
        } else if (target instanceof PropertyCollection) {
            entries = ((PropertyCollection)target).values();
        }
        if (entries != null) {
            if (!entries.isEmpty()) {
                for (Object entry : entries) {
                    if (entry instanceof IMObject) {
                        IMObject imobj = (IMObject)entry;
                        boolean match = false;
                        if (!node.matchesFilter(imobj)) continue;
                        for (ArchetypeRangeInfo type : atypes) {
                            if (!StringUtilities.matches(imobj.getArchetype(), type.shortName)) continue;
                            ++type.count;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        return false;
                    }
                    return false;
                }
            }
            for (ArchetypeRangeInfo type : atypes) {
                if (type.count >= type.minCardinality && (type.maxCardinality == -1 || type.count <= type.maxCardinality)) continue;
                return false;
            }
            return true;
        }
        if (target instanceof IMObjectReference) {
            IMObjectReference imref = (IMObjectReference)target;
            for (ArchetypeRangeInfo type : atypes) {
                if (!imref.getArchetypeId().getShortName().matches(StringUtilities.toRegEx(type.shortName))) continue;
                return true;
            }
        }
        return false;
    }

    private static List<ArchetypeRangeInfo> getArchetypeRangeInfo(AssertionDescriptor desc) {
        ArrayList<ArchetypeRangeInfo> infos = new ArrayList<ArchetypeRangeInfo>();
        PropertyList archetypes = (PropertyList)desc.getPropertyMap().getProperties().get("archetypes");
        for (NamedProperty archetype : archetypes.getProperties()) {
            ArchetypeRangeInfo info = new ArchetypeRangeInfo();
            AssertionProperty prop = (AssertionProperty)((PropertyMap)archetype).getProperties().get("shortName");
            if (prop == null) {
                logger.warn("archetypeRangeAssertion does not specify a short name");
                continue;
            }
            info.shortName = prop.getValue();
            prop = (AssertionProperty)((PropertyMap)archetype).getProperties().get("minCardinality");
            info.minCardinality = prop == null ? 0 : Integer.parseInt(prop.getValue());
            prop = (AssertionProperty)((PropertyMap)archetype).getProperties().get("maxCardinality");
            info.maxCardinality = prop == null ? -1 : Integer.parseInt(prop.getValue());
            prop = (AssertionProperty)((PropertyMap)archetype).getProperties().get("defaultValue");
            if (prop != null) {
                info.defaultValue = prop.getValue();
            }
            infos.add(info);
        }
        return infos;
    }

    private static class ArchetypeRangeInfo {
        String shortName;
        String defaultValue;
        int minCardinality;
        int maxCardinality;
        int count;

        private ArchetypeRangeInfo() {
        }
    }
}

