/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;

public class AbstractRelationshipAssertions {
    protected <T extends IMObjectRelationship> boolean contains(T relationship, List<T> active) {
        IMObjectReference source = relationship.getSource();
        IMObjectReference target = relationship.getTarget();
        for (IMObjectRelationship other : active) {
            if (!Objects.equals(source, other.getSource()) || !Objects.equals(target, other.getTarget())) continue;
            return true;
        }
        active.add(relationship);
        return false;
    }

    protected <T extends IMObjectRelationship> boolean validateUnique(Collection<T> entries) {
        if (entries.size() > 1) {
            ArrayList active = new ArrayList();
            for (IMObjectRelationship entry : entries) {
                if (!entry.isActive() || !this.contains(entry, active)) continue;
                return false;
            }
        }
        return true;
    }

    protected <T extends IMObjectRelationship> boolean validateUniqueType(Collection<T> entries) {
        if (entries.size() > 1) {
            HashSet<String> types = new HashSet<String>();
            for (IMObjectRelationship entry : entries) {
                String shortName;
                if (!entry.isActive() || types.add(shortName = entry.getArchetypeId().getShortName())) continue;
                return false;
            }
        }
        return true;
    }

    protected <T extends IMObjectRelationship> Collection<T> getRelationships(Object object, Class<T> type) {
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            for (Object element : list) {
                if (type.isAssignableFrom(element.getClass())) continue;
                return null;
            }
            return (Collection)object;
        }
        return null;
    }
}

